package com.xebialabs.deployit.core.api.resteasy;

import java.util.Arrays;
import java.util.List;

import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;

import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.jboss.resteasy.plugins.providers.ByteArrayProvider;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.providers.StringTextStar;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBElementProvider;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBXmlRootElementProvider;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBXmlSeeAlsoProvider;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBXmlTypeProvider;
import org.jboss.resteasy.plugins.providers.jaxb.XmlJAXBContextFinder;
import org.jboss.resteasy.plugins.providers.multipart.ListMultipartReader;
import org.jboss.resteasy.plugins.providers.multipart.ListMultipartWriter;
import org.jboss.resteasy.plugins.providers.multipart.MapMultipartFormDataReader;
import org.jboss.resteasy.plugins.providers.multipart.MapMultipartFormDataWriter;
import org.jboss.resteasy.plugins.providers.multipart.MimeMultipartProvider;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormAnnotationReader;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormAnnotationWriter;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataReader;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataWriter;
import org.jboss.resteasy.plugins.providers.multipart.MultipartReader;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedReader;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedWriter;
import org.jboss.resteasy.plugins.providers.multipart.MultipartWriter;
import org.jboss.resteasy.plugins.providers.multipart.XopWithMultipartRelatedReader;
import org.jboss.resteasy.plugins.providers.multipart.XopWithMultipartRelatedWriter;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

import com.google.common.collect.Lists;
import org.jboss.resteasy.spi.interception.PostProcessInterceptor;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;

/**
 */
public class ResteasyHelper {

	public static class ResteasyProviderFactoryBuilder {
		private ResteasyProviderFactory factory;

        private List<Class<? extends MessageBodyReader<?>>> readers = Lists.newArrayList();
		private List<Class<? extends MessageBodyWriter<?>>> writers = Lists.newArrayList();
		private List<ClientErrorInterceptor> errorInterceptors = Lists.newArrayList();
		private List<Class<? extends ContextResolver<?>>> contextResolvers = Lists.newArrayList();
		private List<Class<? extends ExceptionMapper<?>>> exceptionMappers = Lists.newArrayList();
        private List<Class<? extends PreProcessInterceptor>> preProcessInterceptors = Lists.newArrayList();
        private List<Class<? extends PostProcessInterceptor>> postProcessInterceptors = Lists.newArrayList();

		private ResteasyProviderFactoryBuilder(final ResteasyProviderFactory factory) {
			this.factory = factory;
		}

		private void registerWriters() {
			for (Class<? extends MessageBodyWriter<?>> writer : writers) {
				factory.addMessageBodyWriter(writer);
			}
		}

		private void registerReaders() {
			for (Class<? extends MessageBodyReader<?>> reader : readers) {
				factory.addMessageBodyReader(reader);
			}
		}

		private void registerClientErrorInterceptors() {
			for (ClientErrorInterceptor interceptor : errorInterceptors) {
				factory.addClientErrorInterceptor(interceptor);
			}
		}

		private void registerContextResolvers() {
			for (Class<? extends ContextResolver<?>> contextResolver : contextResolvers) {
				factory.addContextResolver(contextResolver);
			}
		}

		private void registerExceptionMappers() {
			for (Class<? extends ExceptionMapper<?>> exceptionMapper : exceptionMappers) {
				factory.addExceptionMapper(exceptionMapper);
			}
		}

        private void registerInterceptors() {
            for (Class<? extends PreProcessInterceptor> preProcessInterceptor : preProcessInterceptors) {
                factory.getServerPreProcessInterceptorRegistry().register(preProcessInterceptor);
            }
            for (Class<? extends PostProcessInterceptor> postProcessInterceptor : postProcessInterceptors) {
                factory.getServerPostProcessInterceptorRegistry().register(postProcessInterceptor);
            }
        }

		public ResteasyProviderFactoryBuilder addReader(Class<? extends MessageBodyReader<?>>... reader) {
			readers.addAll(Arrays.asList(reader));
			return this;
		}

		public ResteasyProviderFactoryBuilder addWriter(Class<? extends MessageBodyWriter<?>>... writer) {
			writers.addAll(Arrays.asList(writer));
			return this;
		}

		public ResteasyProviderFactoryBuilder addContextResolver(final Class<? extends ContextResolver<?>>... contextFinderClasses) {
			contextResolvers.addAll(Arrays.asList(contextFinderClasses));
			return this;
		}

		public ResteasyProviderFactoryBuilder addClientErrorInterceptor(ClientErrorInterceptor... interceptor) {
			errorInterceptors.addAll(Arrays.asList(interceptor));
			return this;
		}

		public ResteasyProviderFactoryBuilder addExceptionMapper(Class<? extends ExceptionMapper<?>>... exceptionMapper) {
			exceptionMappers.addAll(Arrays.asList(exceptionMapper));
			return this;
		}

        public ResteasyProviderFactoryBuilder addPreProcessInterceptor(Class<? extends PreProcessInterceptor>... preProcessInterceptor) {
            preProcessInterceptors.addAll(Arrays.asList(preProcessInterceptor));
            return this;
        }

        public ResteasyProviderFactoryBuilder addPostProcessInterceptor(Class<? extends PostProcessInterceptor>... postProcessInterceptor) {
            postProcessInterceptors.addAll(Arrays.asList(postProcessInterceptor));
            return this;
        }

		public void build() {
			registerReaders();
			registerWriters();
			registerClientErrorInterceptors();
			registerContextResolvers();
			registerExceptionMappers();
            registerInterceptors();
			try {
				RegisterBuiltin.registerProviders(factory);
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		}

		private ResteasyProviderFactoryBuilder addGenericProviders() {
			addReaderWriter(StringTextStar.class);
			addReaderWriter(ByteArrayProvider.class);
			return this;
		}
		
		@SuppressWarnings("unchecked")
        private <T extends MessageBodyReader<?> & MessageBodyWriter<?>> ResteasyProviderFactoryBuilder addReaderWriter(Class<T> readerWriter) {
			addReader(readerWriter);
			addWriter(readerWriter);
			return this;
		}

		@SuppressWarnings("unchecked")
        private ResteasyProviderFactoryBuilder addMultipartProviders() {
			addReader(MultipartReader.class, MultipartRelatedReader.class, MultipartFormDataReader.class, ListMultipartReader.class, MapMultipartFormDataReader.class, MultipartFormAnnotationReader.class, MimeMultipartProvider.class, XopWithMultipartRelatedReader.class);
			addWriter(MultipartWriter.class, MultipartRelatedWriter.class, MultipartFormDataWriter.class, ListMultipartWriter.class, MapMultipartFormDataWriter.class, MultipartFormAnnotationWriter.class, MimeMultipartProvider.class, XopWithMultipartRelatedWriter.class);
			return this;
		}

		@SuppressWarnings("unchecked")
        private ResteasyProviderFactoryBuilder addJaxbProviders() {
			addReader(JAXBXmlRootElementProvider.class, JAXBXmlTypeProvider.class, JAXBXmlSeeAlsoProvider.class, JAXBElementProvider.class);
			addWriter(JAXBXmlRootElementProvider.class, JAXBXmlTypeProvider.class, JAXBXmlSeeAlsoProvider.class, JAXBElementProvider.class);
			addContextResolver(XmlJAXBContextFinder.class);
			return this;
		}
		
		@SuppressWarnings("unchecked")
		private ResteasyProviderFactoryBuilder addCsvProviders() {
			addWriter(CsvMessageProvider.class);
			return this;
		}
	}

	public static ResteasyProviderFactoryBuilder buildDefaultResteasyProviderFactory() {
		ResteasyProviderFactory rpf = ResteasyProviderFactory.getInstance();
		final ResteasyProviderFactoryBuilder builder = new ResteasyProviderFactoryBuilder(rpf);
		builder.addCsvProviders().addGenericProviders().addJaxbProviders().addMultipartProviders();
		builder.addClientErrorInterceptor(new InternalServerErrorClientResponseInterceptor());
		return builder;
	}

}
