package com.xebialabs.deployit.core.api;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.xebialabs.deployit.core.api.dto.Deployment;
import org.jboss.resteasy.annotations.ClientResponseType;

import com.xebialabs.deployit.core.api.dto.Steps;

/**
 */
@SuppressWarnings("deprecation")
@Path("/deployment")
@Consumes(MediaType.APPLICATION_XML)
@Produces(MediaType.APPLICATION_XML)
public interface DeploymentProxy {

	@GET
	@Path("initial")
	@ClientResponseType(entityType = Deployment.class)
	Response prepareInitial(@QueryParam("version") String versionId, @QueryParam("environment") String environmentId);

	@GET
	@Path("upgrade")
	@ClientResponseType(entityType = Deployment.class)
	Response prepareUpgrade(@QueryParam("version") String versionId, @QueryParam("deployedApplication") String deployedApplicationId);

    @POST
    @Path("generate-all")
    @ClientResponseType(entityType = Deployment.class)
    Response generateAllDeployeds(Deployment deployment);

	@POST
	@Path("generate-selected")
	@ClientResponseType(entityType = Deployment.class)
	Response generateSelectedDeployeds(@QueryParam("deployables") List<String> deployableIds, Deployment deployment);

    @POST
    @Path("generate")
    @ClientResponseType(entityType = Deployment.class)
    Response generateSingleDeployed(@QueryParam("deployable") String deployableId, @QueryParam("container") String containerId, @QueryParam("deployedtype") String deployedType, Deployment deployment);

	@POST
	@Path("validate")
	@ClientResponseType(entityType = Deployment.class)
	Response validate(Deployment deployment);

    @POST
    @Path("deploy")
    @ClientResponseType(entityType = Steps.class)
    Response deploy(Deployment deployment);

	@POST
	@Path("undeploy")
	@ClientResponseType(entityType = Steps.class)
	Response undeploy(String deployedApplicationId);
}
