package com.xebialabs.deployit.core.api;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.jboss.resteasy.annotations.ClientResponseType;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;

import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos;

@Path("/repository")
@Consumes({ MediaType.APPLICATION_XML })
@Produces({ MediaType.APPLICATION_XML })
public interface RepositoryProxy {

	@POST
	@Path("{id:.*?}")
	@ClientResponseType(entityType = ConfigurationItemDto.class)
	Response create(@PathParam("id") String id, ConfigurationItemDto entity);

	@POST
	@Path("{id:.*?}")
	@Consumes({ MediaType.MULTIPART_FORM_DATA })
	@ClientResponseType(entityType = ConfigurationItemDto.class)
	Response create(@PathParam("id") String id, @MultipartForm ArtifactAndData artifactAndData);

    @POST
	@Path("create-multiple")
	@ClientResponseType(entityType = ConfigurationItemDtos.class)
	Response createMultiple(ConfigurationItemDtos repositoryObjects);

	@GET
	@Path("{id:.*?}")
	@ClientResponseType(entityType = ConfigurationItemDto.class)
	Response read(@PathParam("id") String id);

	@PUT
	@Path("{id:.*?}")
	@ClientResponseType(entityType = ConfigurationItemDto.class)
	Response update(@PathParam("id") String id, ConfigurationItemDto entity);

	@PUT
	@Path("{id:.*?}")
	@Consumes({ MediaType.MULTIPART_FORM_DATA })
	@ClientResponseType(entityType = ConfigurationItemDto.class)
	Response update(@PathParam("id") String id, @MultipartForm ArtifactAndData artifactAndData);

	@DELETE
	@Path("{id:.*?}")
	Response delete(@PathParam("id") String id);

}
