package com.xebialabs.deployit.core.api.resteasy.http.tunnel;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collections;

/**
 */
@XmlRootElement(name = "response")
public class TunneledResponse {

	private int status;
	private String entity;

	@XmlJavaTypeAdapter(HeaderMultimapAdapter.class)
	private Multimap<String, String> headers = ArrayListMultimap.create();

	@XmlElement(name = "status")
	public int getStatus() {
		return status;
	}

	@XmlElement(name = "entity")
	public String getEntity() {
		return entity;
	}

	public void setStatus(final int status) {
		this.status = status;
	}

	public void setEntity(final String entity) {
		this.entity = entity;
	}

	public void addSingleHeader(final String headerName, final Object headerValue) {
		headers.replaceValues(headerName, Collections.singletonList(headerValue.toString()));
	}

	public void addHeader(final String headerName, final Object headerValue) {
		headers.put(headerName, headerValue.toString());
	}
}
