/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.jaxb;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.jaxb.CollectionOfStringsMapElement;
import com.xebialabs.deployit.core.api.jaxb.MapElement;
import com.xebialabs.deployit.core.api.jaxb.MapMapElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapAdapter
extends XmlAdapter<MapElement[], Map<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(MapAdapter.class);

    /*
     * Enabled aggressive block sorting
     */
    public MapElement[] marshal(Map<String, Object> map) throws Exception {
        ArrayList arrayList = Lists.newArrayList();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object object;
                Object object2;
                Object object3 = entry.getValue();
                if (object3 instanceof Map) {
                    object2 = new MapMapElement((Map)object3);
                } else if (object3 instanceof Collection) {
                    object = (Collection)object3;
                    if (object.isEmpty()) {
                        object2 = null;
                    } else {
                        Object e = object.iterator().next();
                        if (!(e instanceof String)) {
                            String string = entry.getKey() + " is a collection but the contents " + e + " is not String";
                            logger.error(string);
                            throw new IllegalArgumentException(string);
                        }
                        object2 = new CollectionOfStringsMapElement((Collection<String>)object);
                    }
                } else if (object3 instanceof String) {
                    object2 = object3;
                } else {
                    if (!(object3 instanceof RepositoryObject)) {
                        object = "Property " + entry.getKey() + " is not a Collection, String or RepositoryObject, but a " + object3.getClass();
                        logger.error((String)object);
                        throw new IllegalArgumentException((String)object);
                    }
                    object2 = object3;
                }
                if (object2 == null) continue;
                arrayList.add(new MapElement(entry.getKey(), object2));
            }
        }
        return arrayList.toArray(new MapElement[arrayList.size()]);
    }

    public Map<String, Object> unmarshal(MapElement[] mapElementArray) throws Exception {
        HashMap hashMap = Maps.newHashMap();
        for (MapElement mapElement : mapElementArray) {
            Object object;
            Object object2 = mapElement.getValue();
            if (object2 instanceof CollectionOfStringsMapElement) {
                object = ((CollectionOfStringsMapElement)object2).getStrings();
            } else if (object2 instanceof MapMapElement) {
                object = ((MapMapElement)object2).getMap();
            } else if (object2 instanceof String) {
                object = (String)object2;
            } else if (object2 instanceof RepositoryObject) {
                object = (RepositoryObject)object2;
            } else {
                String string = "Property " + mapElement.getKey() + " is not of a recognized type but it is: " + object2;
                logger.error(string);
                throw new IllegalArgumentException(string);
            }
            hashMap.put(mapElement.getKey(), object);
        }
        return hashMap;
    }
}

