package com.xebialabs.deployit.core.api.dto;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

@XmlRootElement
public class RoleAssignments extends AbstractDTO {

	private List<RoleAssignment> assignments = newArrayList();

	public RoleAssignments() {
	}

	public RoleAssignments(List<RoleAssignment> assignments) {
		this.assignments = assignments;
	}

	@XmlElement
	public List<RoleAssignment> getAssignments() {
		return assignments;
	}

	public void setAssignments(List<RoleAssignment> assignments) {
		this.assignments = assignments;
	}
	
	public void assignRole(final String role, List<String> principals) {
        Collection<RoleAssignment> filter = Collections2.filter(assignments, new Predicate<RoleAssignment>() {
            public boolean apply(RoleAssignment input) {
                return input.getRole().getName().equals(role);
            }
        });

        if (!filter.isEmpty()) {
            filter.iterator().next().setPrincipals(principals);
        } else {
            this.assignments.add(new RoleAssignment(new Role(role), principals));
        }
	}
	
	public void removeRole(String role) {
		for (Iterator<RoleAssignment> it = assignments.iterator(); it.hasNext();) {
			RoleAssignment ra = it.next();
			if (ra.getRole().getName().equals(role)) {
				it.remove();
				break;
			}
		}
	}
}
