package com.xebialabs.deployit.core.api;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.MediaType;

import com.xebialabs.deployit.core.api.dto.*;
import org.jboss.resteasy.annotations.ClientResponseType;

@Path("/security")
@Consumes({ MediaType.APPLICATION_XML })
@Produces({ MediaType.APPLICATION_XML })
public interface SecurityProxy {

	@GET
	@Path("retrieve/{user}")
	@Produces({MediaType.APPLICATION_XML})
	@ClientResponseType(entityType = PrincipalPermissions.class)
	public Response retrievePermissions(@PathParam("user") String user);

	@GET
	@Path("retrieve/")
	@ClientResponseType(entityType = PrincipalPermissions.class)
	public Response retrievePermissionsForCurrentUser();
	
	@GET
	@Path("permissions/{id:.*?}")
	@ClientResponseType(entityType = RolePermissions.class)
	public Response getGrantedPermissions(@PathParam("id") String id);
	
	@POST
	@Path("permissions/{id:.*?}")
	public Response writeGrantedPermissions(@PathParam("id") String id, RolePermissions permissions);
	
	@GET
	@Path("roles/assignments")
	@ClientResponseType(entityType = RoleAssignments.class)
	public Response getRoleAssignments();

	@POST
	@Path("roles/assignments")
	public Response writeRoleAssignments(RoleAssignments assignments);

	@GET
	@Path("roles")
	@ClientResponseType(entityType = Roles.class)
	public Response getRoles();

    @POST
    @Path("logout")
    public Response logout();

	@GET
	@Path("permission/{permission}/{id:.*?}")
	Response hasPermission(@PathParam("permission") String permission, @PathParam("id") String id);
}
