package com.xebialabs.deployit.core.api.jaxb;

import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;


@XmlType(name = "map")
public class MapMapElement {

    private MapEntry[] mapEntries = new MapEntry[0];

    public MapMapElement() {
    }

    public MapMapElement(final Map<String, String> map) {
        List<MapEntry> entries = Lists.newArrayList();
        for (Map.Entry<String, String> eachEntry : map.entrySet()) {
            entries.add(new MapEntry(eachEntry));
        }
        this.mapEntries = entries.toArray(new MapEntry[entries.size()]);
    }

    @XmlElement(name = "map")
    public MapEntry[] getMapEntries() {
        return mapEntries;
    }

    public void setMapEntries(MapEntry[] map) {
        this.mapEntries = map;
    }

    @XmlTransient
    public Map<String, String> getMap() {
        Map<String, String> m = Maps.newHashMap();
        for (MapEntry eachEntry : mapEntries) {
            m.put(eachEntry.getKey(), eachEntry.getValue());
        }
        return m;
    }

    @XmlRootElement()
    public static class MapEntry {
        private String key;

        private String value;

        public MapEntry() {
        }

        public MapEntry(Map.Entry<String, String> mapEntry) {
            this.key = mapEntry.getKey();
            this.value = mapEntry.getValue();
        }

        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }

    }

}
