package com.xebialabs.deployit.core.api.dto;

import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import com.xebialabs.deployit.core.api.jaxb.MapAdapter;
import com.xebialabs.deployit.engine.api.xml.OmitXmlPreamble;

@XmlRootElement
@OmitXmlPreamble
public class Report {

    List<ReportLine> lines = Lists.newArrayList();

    @XmlElement(name = "lines")
    public List<ReportLine> getLines() {
        return lines;
    }

    public void setLines(final List<ReportLine> lines) {
        this.lines = lines;
    }

    public ReportLine addLine() {
        final ReportLine reportLine = new ReportLine();
        lines.add(reportLine);
        return reportLine;
    }

    public static class ReportLine {
        Map<String, Object> values = Maps.newHashMap();

        @XmlJavaTypeAdapter(MapAdapter.class)
        public Map<String, Object> getValues() {
            return values;
        }

        public void setValues(final Map<String, Object> values) {
            this.values = values;
        }

        public void addValue(String key, Object value) {
            this.values.put(key, value);
        }

        @Override
        public String toString() {
            return "ReportLine [" + values + "]";
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
