package com.xebialabs.xlplatform.rest.script.endpoints

import spray.routing.{PathMatcher0, PathMatchers}
import org.slf4j.{LoggerFactory, Logger}
import com.xebialabs.xlplatform.rest.script.ResourceUtils
import java.net.URL

case class Endpoint(path: String, method: String, script: URL) {

  def getPathMatcher: PathMatcher0 = PathMatchers.separateOnSlashes(cleanPath)

  def cleanPath: String = {
    path.split('/').filterNot(_.isEmpty).mkString("/")
  }
}

object Endpoints {

  import ResourceUtils._

  val log: Logger = LoggerFactory.getLogger(Endpoints.getClass)

  def apply(config: String): Seq[Endpoint] = {
    (loadXmlResources(config) \ "endpoint").map {e =>
      Endpoint((e \ "@path").text, (e \ "@method").text, findFile((e \ "@script").text))
    }
  }

  private def findFile(p: String): URL = {
    Option(Thread.currentThread().getContextClassLoader.getResource(p)) match {
      case Some(url) => url
      case None => throw new IllegalArgumentException(s"Can not find script [$p]")
    }
  }

}
