package com.xebialabs.deployit.server.api.upgrade;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version implements Comparable<Version> {

    public static final String VERSION_0 = "0.0.0";

    private String component;
    private int major;
    private int minor;
    private int micro;
    private String classifier = "";

    public static Version valueOf(String component, String versionString) {
    	Matcher matcher = Pattern.compile("([0-9]+)\\.([0-9]+)\\.?([0-9]+)?-?(.*)$").matcher(versionString);
    	if(!matcher.matches()) {
    		throw new RuntimeException("Unsupported version number format " + versionString);
    	}

        Version version = new Version();
        version.component = component;
        version.major = Integer.parseInt(matcher.group(1));
        version.minor = Integer.parseInt(matcher.group(2));

        if (matcher.group(3) != null) {
            version.micro = Integer.parseInt(matcher.group(3));
        }

        if (matcher.group(4) != null) {
        	version.classifier = matcher.group(4);
        }

        return version;
    }

    public String getComponent() {
        return component;
    }

    public int getMajor() {
        return major;
    }

    public int getMinor() {
        return minor;
    }

    public int getMicro() {
        return micro;
    }

    public String getClassifier() {
        return classifier;
    }

    public String getVersion() {
        if (classifier.isEmpty()) {
            return String.format("%d.%d.%d", major, minor, micro);
        }
        return String.format("%d.%d.%d-%s", major, minor, micro, classifier);
    }

    @Override
    public String toString() {
        return String.format("%s %s", component, getVersion());
    }

    @Override
    public int compareTo(Version o) {
        if (!component.equals(o.component)) {
            throw new IllegalArgumentException("Cannot compare versions for 2 components: " + toString() + " and " + o.toString());
        } else if (major != o.major) {
            return major - o.major;
        } else if (minor != o.minor) {
            return minor - o.minor;
        } else if (micro != o.micro) {
            return micro - o.micro;
        } else {
            return classifier.compareTo(o.classifier);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Version version = (Version) o;

        return major == version.major
                && micro == version.micro
                && minor == version.minor
                && classifier.equals(version.classifier)
                && component.equals(version.component);

    }

    @Override
    public int hashCode() {
        int result = component.hashCode();
        result = 31 * result + major;
        result = 31 * result + minor;
        result = 31 * result + micro;
        result = 31 * result + (classifier.hashCode());
        return result;
    }
}
