package com.xebialabs.deployit.server.api.orchestrator;

import com.xebialabs.deployit.plugin.api.reflect.ReflectionsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;

import static com.google.common.collect.Maps.newHashMap;
import static com.google.common.collect.Sets.newHashSet;

public class OrchestratorRegistry {

	private static final Logger logger = LoggerFactory.getLogger(OrchestratorRegistry.class);
	private static Map<String, Orchestrator> lookup = newHashMap();
	
	static {
		Set<Class<? extends Orchestrator>> orchestratorClasses = ReflectionsHolder.getSubTypesOf(Orchestrator.class);
		for (Class<? extends Orchestrator> orchestratorClass : orchestratorClasses) {
			try {
				register(orchestratorClass);
			} catch (Exception e) {
				throw new RuntimeException("Couldn't boot the OrchestratorRegistry", e);
			}		
		}
	}

	private static void register(Class<? extends Orchestrator> orchestratorClass) throws IllegalAccessException, InstantiationException {
		if (Modifier.isAbstract(orchestratorClass.getModifiers())) return;

		String name = orchestratorClass.getSimpleName();
		if (orchestratorClass.isAnnotationPresent(Orchestrator.Metadata.class)) {
			Orchestrator.Metadata annotation = orchestratorClass.getAnnotation(Orchestrator.Metadata.class);
			name = annotation.name();
		}
		logger.info("Registering Orchestrator [{}] under name [{}]", orchestratorClass, name);
		lookup.put(name, orchestratorClass.newInstance());
	}

	public static Orchestrator getOrchestrator(String name) {
		return lookup.get(name);
	}
	
	public static Set<String> all() {
		return newHashSet(lookup.keySet());
	}
}
