/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.xebialabs.deployit.DeployitBootstrapper;
import com.xebialabs.deployit.Server;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.setup.Setup;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlplatform.config.ConfigLoader;
import com.xebialabs.xlplatform.jmx.JMXAgent;
import com.xebialabs.xlplatform.jmx.JMXSettings;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.crypto.SecretKey;
import kamon.Kamon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLDeployServer {
    private static final Logger logger = LoggerFactory.getLogger(XLDeployServer.class);
    private static final String XL_JMX_KEY = "xl.jmx";
    private static final String KAMON_KEY = "kamon";
    private static final List<File> DEPRECATED_SYSTEM_CONFIG_FILES = Arrays.asList(new File("conf", "system.conf"), new File("conf", "maven.conf"), new File("conf", "extensions.conf"), new File("conf", "planner.conf"), new File("conf", "scheduler.conf"));
    private final ServerLaunchOptions launchOptions;
    private final ServerConfigFile serverConfigFile;
    private boolean isConfigAndPasswordInitDone = false;

    public XLDeployServer(ServerLaunchOptions launchOptions, ServerConfigFile serverConfigFile) {
        this.launchOptions = launchOptions;
        this.serverConfigFile = serverConfigFile;
    }

    void prepareConfigs() {
        this.checkDeprecatedSystemConf();
        if (this.launchOptions.isDoSetup()) {
            XLDeployServer.startSetup(this.launchOptions, this.serverConfigFile);
        } else {
            if (!this.serverConfigFile.exists()) {
                logger.warn("Configuration not found...");
                XLDeployServer.startSetup(this.launchOptions, this.serverConfigFile);
            } else if (this.launchOptions.isReinitialize()) {
                logger.warn("Not re-initializing as the -setup flag is missing.");
            }
            if (!this.isConfigAndPasswordInitDone) {
                this.loadConfigAndInitPasswordEncryptionKey();
            }
            Config config = ConfigLoader.loadWithDynamic((String)"xl-deploy.conf");
            this.initializeJMXAgent(config);
        }
    }

    void start() {
        ServerConfiguration serverConfiguration = this.serverConfigFile.loadConfig(false, false);
        this.checkDatabaseConfiguration(serverConfiguration);
        XLDeployServer.startServer(this.launchOptions, this.serverConfigFile, serverConfiguration);
        DeployitBootstrapper.setUpTrustStorePassword();
    }

    private void checkDatabaseConfiguration(ServerConfiguration serverConfiguration) {
        boolean repositoryDbPasswordMissing;
        Config xldConfig = ConfigFactory.parseResources((String)"xl-deploy.conf");
        boolean repositoryDbDriverMissing = !this.hasPath(xldConfig, "xl.repository.database.db-driver-classname") && !Objects.nonNull(serverConfiguration.getJdbcDriverClassName());
        boolean repositoryDbUrlMissing = !this.hasPath(xldConfig, "xl.repository.database.db-url") && !Objects.nonNull(serverConfiguration.getJdbcUrl());
        boolean repositoryDbUsernameMissing = !this.hasPath(xldConfig, "xl.repository.database.db-username") && !Objects.nonNull(serverConfiguration.getJdbcUsername());
        boolean bl = repositoryDbPasswordMissing = !this.hasPath(xldConfig, "xl.repository.database.db-password") && !Objects.nonNull(serverConfiguration.getJdbcPassword());
        if (repositoryDbDriverMissing || repositoryDbUrlMissing || repositoryDbUsernameMissing || repositoryDbPasswordMissing) {
            logger.error("Database is not configured properly in xl-deploy.conf");
            if (repositoryDbDriverMissing) {
                logger.error("Property `xl.repository.database.db-driver-classname` not found, please configure it in your xl-deploy.conf.");
            }
            if (repositoryDbUrlMissing) {
                logger.error("Property `xl.repository.database.db-url` not found, please configure it in your xl-deploy.conf.");
            }
            if (repositoryDbUsernameMissing) {
                logger.error("Property `xl.repository.database.db-username` not found, please configure it in your xl-deploy.conf.");
            }
            if (repositoryDbPasswordMissing) {
                logger.error("Property `xl.repository.database.db-password` not found, please configure it in your xl-deploy.conf.");
            }
            logger.error("You can also setup the server with `-setup -setup-defaults conf/poc-setup.properties` flag if you want to use the in-memory database for testing purposes.");
            logger.error("NB! In-memory database NOT recommended for production.");
            System.exit(1);
        }
    }

    private boolean hasPath(Config config, String path) {
        return config.entrySet().stream().anyMatch(e -> ((String)e.getKey()).equals(path));
    }

    private void checkDeprecatedSystemConf() {
        DEPRECATED_SYSTEM_CONFIG_FILES.forEach(configFile -> {
            if (configFile.exists()) {
                throw new RuntimeException("You are not allowed to have a " + configFile.getName() + " file on the 'conf' folder. Please merge it into 'conf/xl-deploy.conf', remove the file and restart the server.");
            }
        });
    }

    private void initializeJMXAgent(Config config) {
        JMXSettings jmxSettings = new JMXSettings(config);
        new JMXAgent().start(jmxSettings);
        if (jmxSettings.enabled()) {
            Config xlJmxConfig = config.getConfig(XL_JMX_KEY);
            Config defaultKamonConfig = config.withOnlyPath(KAMON_KEY);
            Config kamonConfig = xlJmxConfig.hasPath(KAMON_KEY) ? xlJmxConfig.withOnlyPath(KAMON_KEY).withFallback((ConfigMergeable)defaultKamonConfig) : defaultKamonConfig;
            Kamon.start((Config)kamonConfig);
        }
    }

    private static void startServer(ServerLaunchOptions launchOptions, ServerConfigFile serverConfigFile, ServerConfiguration serverConfiguration) {
        logger.info("Starting server...");
        try {
            Server.start("XL Deploy Server", launchOptions, serverConfigFile, serverConfiguration);
        }
        catch (Exception e) {
            logger.error("Fatal error starting server");
            logger.error(e.getMessage());
            System.exit(1);
        }
    }

    private static void startSetup(ServerLaunchOptions launchOptions, ServerConfigFile serverConfigFile) {
        new Setup("XL Deploy Server", serverConfigFile, launchOptions).run();
    }

    void loadConfigAndInitPasswordEncryptionKey() {
        ServerConfiguration config = this.serverConfigFile.loadConfig(false, false);
        String repositoryKeyStorePassword = this.launchOptions.getRepositoryKeystorePassword() != null ? this.launchOptions.getRepositoryKeystorePassword() : config.getRepositoryKeyStorePassword();
        try {
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeyStorePassword);
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            throw new RuntimeException("Could not load the encryption key. The server will not start.");
        }
        config.loadEncryptedPasswords();
        this.serverConfigFile.saveDirtyConfiguration(config);
        ServerConfiguration.setInstance((ServerConfiguration)config);
        ServerLaunchOptions.setInstance((ServerLaunchOptions)this.launchOptions);
        this.isConfigAndPasswordInitDone = true;
    }
}

