/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.xebialabs.deployit.DeployitBootstrapper;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.XLDeployServer;
import com.xebialabs.deployit.XldServerPaths;
import com.xebialabs.deployit.env.InitialCentralConfigSetup$;
import com.xebialabs.deployit.log.LogbackHelper;
import com.xebialabs.deployit.upgrade.CentralConfigVersionFile;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.platform.script.jython.EngineInstance$;
import com.xebialabs.plugin.Xlp$;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public final class ApplicationBooter$ {
    public static final ApplicationBooter$ MODULE$ = new ApplicationBooter$();
    private static final Logger logger = LoggerFactory.getLogger(DeployitBootstrapper.class);
    private static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static final CentralConfigVersionFile centralConfigVersionFile = new CentralConfigVersionFile(XldServerPaths.DEFAULT_CENTRAL_CONFIG_VERSION_FILE, XldServerPaths.DEFAULT_CONFIGURATION_FILE, XldServerPaths.CENTRAL_CONFIG_FOLDER, XldServerPaths.CONFIG_FOLDER);
    private static XLDeployServer xlDeployServer;

    private Logger logger() {
        return logger;
    }

    public String JAVAX_NET_SSL_TRUST_STORE_PASSWORD() {
        return JAVAX_NET_SSL_TRUST_STORE_PASSWORD;
    }

    public CentralConfigVersionFile centralConfigVersionFile() {
        return centralConfigVersionFile;
    }

    public XLDeployServer xlDeployServer() {
        return xlDeployServer;
    }

    public void xlDeployServer_$eq(XLDeployServer x$1) {
        xlDeployServer = x$1;
    }

    public void setUpTrustStorePassword() {
        block0: {
            if (!Objects.isNull(System.getProperty(this.JAVAX_NET_SSL_TRUST_STORE_PASSWORD())) || !Objects.nonNull(ServerConfiguration.getInstance()) || !Objects.nonNull(ServerConfiguration.getInstance().getTrustStorePassword())) break block0;
            System.setProperty(this.JAVAX_NET_SSL_TRUST_STORE_PASSWORD(), ServerConfiguration.getInstance().getTrustStorePassword());
        }
    }

    public void boot(String[] args) {
        block1: {
            LogbackHelper.disableConsoleLoggerIfNeeded((String)"STDOUT");
            LogbackHelper.enableJavaUtilLoggingBridge();
            this.setUpDefaultLogLevels();
            Files.createDirectories(XldServerPaths.XL_HOTFIX_PLUGINS_FOLDER.toPath(), new FileAttribute[0]);
            Files.createDirectories(XldServerPaths.XL_PLUGINS_LOCAL_FOLDER.toPath(), new FileAttribute[0]);
            Files.createDirectories(XldServerPaths.XL_PLUGINS_OFFICIAL_FOLDER.toPath(), new FileAttribute[0]);
            Xlp$.MODULE$.init("xldp", (Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{XldServerPaths.XL_HOTFIX_PLUGINS_FOLDER, XldServerPaths.XL_PLUGINS_LOCAL_FOLDER, XldServerPaths.XL_PLUGINS_OFFICIAL_FOLDER}))).asJava(), Collections.singletonList(XldServerPaths.EXT_FOLDER));
            ServerLaunchOptions launchOptions = ServerLaunchOptions.parseCommandLine((String[])args);
            if (launchOptions == null) {
                System.exit(0);
            }
            this.initialiseJython();
            ServerConfigFile serverConfigFile = new ServerConfigFile(XldServerPaths.DEFAULT_CONFIGURATION_FILE);
            Security.addProvider((Provider)new BouncyCastleProvider());
            this.xlDeployServer_$eq(new XLDeployServer(launchOptions, serverConfigFile));
            this.xlDeployServer().prepareConfigs();
            InitialCentralConfigSetup$.MODULE$.setup();
            PasswordEncrypter.init((SecretKey)DeployitKeys.getPasswordEncryptionKey((String)launchOptions.getRepositoryKeystorePassword()));
            if (!launchOptions.isDoSetup()) break block1;
            System.exit(0);
        }
    }

    private void setUpDefaultLogLevels() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.getLogger("org.eclipse.jetty.server.session").setLevel(Level.WARN);
    }

    private void initialiseJython() {
        try {
            this.logger().info("Starting up Jython engine (might take a while)...");
            EngineInstance$.MODULE$.jython().eval("True");
            this.logger().info(new StringBuilder(23).append("Jython engine loaded [").append(EngineInstance$.MODULE$.jython().getFactory().getEngineVersion()).append("]").toString());
        }
        catch (Exception e) {
            this.logger().warn("Exception while initialising jython engine", (Throwable)e);
        }
    }

    private ApplicationBooter$() {
    }
}

