/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.server.jetty;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.server.jetty.JettyServerConnector;
import com.xebialabs.deployit.setup.Setup;
import com.xebialabs.plugin.classloader.PluginClassLoader;
import com.xebialabs.plugin.manager.materializer.PluginsMaterializer;
import java.io.File;
import java.net.ServerSocket;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.Properties;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;

@Component
public class JettyServer
implements WebServerFactoryCustomizer<JettyServletWebServerFactory> {
    @Autowired
    private ServerConfiguration serverConfiguration;
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private PluginsMaterializer pluginsMaterializer;
    private static final Logger logger = LoggerFactory.getLogger(JettyServer.class);

    public void customize(JettyServletWebServerFactory factory) {
        int port = this.serverConfiguration.getHttpPort();
        String webContextRoot = this.serverConfiguration.getWebContextRoot();
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.materializePluginsAndRefreshClassloader();
        Properties defaultProperties = new Properties();
        this.environment.getPropertySources().stream().filter(source -> source.getName().endsWith("deploy-defaults.properties")).forEach(source -> defaultProperties.putAll((Map<?, ?>)((Map)source.getSource())));
        LocalBooter.bootFromProperties((Properties)defaultProperties, (File)Setup.DEPLOY_DEFAULTS);
        if (!this.portIsAvailable()) {
            String name = "XL Deploy Server";
            logger.error("Cannot start {}; port {} already in use.", (Object)name, (Object)port);
            logger.error("Perhaps another instance of {} is running.", (Object)name);
            System.exit(1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Setting up Jetty server on port {} with context root {} using package {} for document root.", new Object[]{port, webContextRoot, "web"});
        }
        if (this.hasNonDefaultContextRoot()) {
            factory.setContextPath(webContextRoot);
        }
        factory.setPort(port);
        factory.setThreadPool((ThreadPool)this.buildThreadPool());
        factory.addServerCustomizers(new JettyServerCustomizer[]{JettyServerConnector.create(this.serverConfiguration)});
    }

    private void materializePluginsAndRefreshClassloader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof PluginClassLoader) {
            ((PluginClassLoader)classLoader).clearClasspathRoots();
        }
        this.pluginsMaterializer.materializePlugins();
        if (classLoader instanceof PluginClassLoader) {
            ((PluginClassLoader)classLoader).refreshDirs();
        }
    }

    private boolean hasNonDefaultContextRoot() {
        String webContextRoot = this.serverConfiguration.getWebContextRoot();
        if (webContextRoot == null || webContextRoot.isBlank()) {
            return false;
        }
        return !webContextRoot.equals("/");
    }

    private QueuedThreadPool buildThreadPool() {
        return new QueuedThreadPool(this.serverConfiguration.getMaxThreads(), this.serverConfiguration.getMinThreads());
    }

    private boolean portIsAvailable() {
        try {
            ServerSocket socket = new ServerSocket(this.serverConfiguration.getHttpPort());
            socket.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

