/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.server.jetty;

import akka.actor.ActorSystem;
import akka.actor.Address;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerState;
import com.xebialabs.deployit.engine.spi.event.SystemStartedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.jetty.DeployitSpringContextLoaderListener;
import com.xebialabs.deployit.tasksystem.TaskActorSystem;
import com.xebialabs.xlplatform.scheduler.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class JettyServerListener
implements ApplicationListener<WebServerInitializedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(JettyServerListener.class);
    private final ServerState serverState = ServerState.getInstance();
    @Autowired
    private ServerConfiguration serverConfiguration;

    public void onApplicationEvent(WebServerInitializedEvent event) {
        new EventListener();
        EventBusHolder.register((Object)this.serverState);
        DeployitSpringContextLoaderListener.checkCorrectlyInitialized();
        EventBusHolder.publish((Object)new SystemStartedEvent());
        logger.info("XL Deploy has started.");
        this.printRemotingAddress();
        logger.info("You can now point your browser to {}", (Object)this.serverConfiguration.getServerUrl());
    }

    private void printRemotingAddress() {
        Address defaultAddress;
        ActorSystem actorSystem = TaskActorSystem.actorSystem();
        if (!actorSystem.settings().config().getBoolean("deploy.task.in-process-worker") && (defaultAddress = actorSystem.provider().getDefaultAddress()).host().isDefined()) {
            logger.info("External workers can connect to {}:{}", defaultAddress.host().get(), defaultAddress.port().get());
        }
    }
}

