/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.server.jetty;

import com.google.common.base.Charsets;
import com.tqdev.metrics.core.MetricRegistry;
import com.tqdev.metrics.http.MeasureRequestPathFilter;
import com.tqdev.metrics.jetty.InstrumentedHandler;
import com.xebialabs.deployit.AcceptHeaderConditionalFilter;
import com.xebialabs.deployit.CustomErrorHandler;
import com.xebialabs.deployit.HttpErrorHandler;
import com.xebialabs.deployit.NoCacheFilter;
import com.xebialabs.deployit.RootPageForwardFilter;
import com.xebialabs.deployit.RootPageMissingErrorHandler;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.XLRequestLogImpl;
import com.xebialabs.deployit.XLWebApplicationContext;
import com.xebialabs.deployit.core.config.ClientProperties;
import com.xebialabs.deployit.core.config.ServerSideProperties;
import com.xebialabs.deployit.errors.LicenseMissingErrorHandler;
import com.xebialabs.deployit.jetty.ClassPathResourceContentServlet;
import com.xebialabs.deployit.jetty.MaintenanceModeFilter;
import com.xebialabs.deployit.jetty.NoOptionsFilter;
import com.xebialabs.deployit.jetty.RequestHeadersEncodedAsParametersFilter;
import com.xebialabs.deployit.server.jetty.DeploySpringContextLoaderListener;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServletInitializer;
import com.xebialabs.xlplatform.endpoints.servlet.FlexAkkaStreamServlet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.SessionTrackingMode;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.util.Assert;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.filter.ShallowEtagHeaderFilter;
import org.springframework.web.servlet.DispatcherServlet;

public class DeployJettyServletWebServerFactory
extends JettyServletWebServerFactory {
    private static final String SPRING_CTX_CFG_LOCATION_KEY = "contextConfigLocation";
    private static final String CONTEXT_PATH = "deployit";
    @Autowired
    private ServerConfiguration serverConfiguration;
    @Autowired
    private ClientProperties clientProperties;
    @Autowired
    private ServerSideProperties serverSideProperties;

    public boolean isRegisterDefaultServlet() {
        return false;
    }

    protected void postProcessWebAppContext(WebAppContext contextRoot) {
        this.setupJetty(contextRoot);
        this.setupApiFilters(contextRoot);
        this.setupRest(contextRoot);
        this.setupAfterAuthFilters(contextRoot);
        this.setupAccessLog(contextRoot);
        this.setSessionHandler(contextRoot);
        this.setupSessionTimeout(contextRoot);
        CustomErrorHandler customErrorHandler = new CustomErrorHandler(new HttpErrorHandler[]{new RootPageMissingErrorHandler(this.serverConfiguration.getWebWelcomePage()), new LicenseMissingErrorHandler()});
        customErrorHandler.setShowStacks(false);
        contextRoot.setErrorHandler((ErrorHandler)customErrorHandler);
    }

    private void setSessionHandler(WebAppContext contextRoot) {
        if (!this.serverSideProperties.getSession().getActiveUserSessionsEnabled()) {
            SessionHandler sessionHandler = new SessionHandler();
            sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
            sessionHandler.setSessionCookie("SESSION_XLD");
            sessionHandler.setHttpOnly(true);
            if (!this.serverConfiguration.isSsl()) {
                sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration.isSecureCookieEnabled());
            }
            contextRoot.setSessionHandler(sessionHandler);
        }
    }

    private void setupSessionTimeout(WebAppContext contextRoot) {
        if (!this.serverSideProperties.getSession().getActiveUserSessionsEnabled()) {
            int sessionTimeoutSeconds = (int)TimeUnit.MINUTES.toSeconds(this.clientProperties.getSession().getTimeoutMinute());
            contextRoot.getSessionHandler().setMaxInactiveInterval(sessionTimeoutSeconds);
        }
    }

    protected Configuration[] getWebAppContextConfigurations(WebAppContext webAppContext, ServletContextInitializer ... initializers) {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        configurations.add(this.getServletContextInitializerConfiguration(webAppContext, initializers));
        configurations.add(this.getMimeTypeConfiguration());
        configurations.addAll(this.getConfigurations());
        return configurations.toArray(new Configuration[0]);
    }

    private Configuration getMimeTypeConfiguration() {
        return new AbstractConfiguration(){

            public void configure(WebAppContext context) {
                MimeTypes mimeTypes = context.getMimeTypes();
                for (MimeMappings.Mapping mapping : DeployJettyServletWebServerFactory.this.getMimeMappings()) {
                    mimeTypes.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
                }
            }
        };
    }

    private void setupAfterAuthFilters(WebAppContext contextRoot) {
        FilterHolder maintenanceFilterHolder = contextRoot.addFilter(MaintenanceModeFilter.class, "*", EnumSet.of(DispatcherType.REQUEST));
        maintenanceFilterHolder.setInitParameter("maintenance.forbidden_paths", String.join((CharSequence)",", this.clientProperties.maintenance().forbiddenPaths()));
        maintenanceFilterHolder.setInitParameter("maintenance.context_root", this.serverConfiguration.getWebContextRoot());
    }

    private void setupAccessLog(WebAppContext contextRoot) {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        XLRequestLogImpl requestLogger = new XLRequestLogImpl("conf/logback-access.xml");
        requestLogHandler.setRequestLog((RequestLog)requestLogger);
        contextRoot.insertHandler((HandlerWrapper)requestLogHandler);
    }

    private void setupApiFilters(WebAppContext contextRoot) {
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        contextRoot.addFilter(filter, "/", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(filter, "/login", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(filter, "/login/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(filter, "/logout", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(filter, "/oauth2/authorization/xl-deploy", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(filter, "/deployit/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(filter, "/api/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(filter, "/xldeploy/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(filter, "/centralConfiguration/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupJetty(WebAppContext contextRoot) {
        contextRoot.addEventListener((EventListener)new AkkaStreamServletInitializer());
        contextRoot.insertHandler((HandlerWrapper)new InstrumentedHandler(MetricRegistry.getInstance()));
        contextRoot.addFilter(MeasureRequestPathFilter.class, "*", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("contentTypes", "application/json|text/html|text/xml|application/xml");
        contextRoot.addFilter(NoOptionsFilter.class, "*", EnumSet.of(DispatcherType.REQUEST));
        if (this.serverConfiguration.getWebWelcomePage() != null) {
            contextRoot.addFilter(RootPageForwardFilter.class, "/", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("ForwardTarget", this.serverConfiguration.getWebWelcomePage());
        }
        contextRoot.addFilter(RequestHeadersEncodedAsParametersFilter.class, "/deployit/reports/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(RequestHeadersEncodedAsParametersFilter.class, "/deployit/repository/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.setClassLoader(Thread.currentThread().getContextClassLoader());
        ServletHolder extensionApiServletHolder = new ServletHolder(FlexAkkaStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        contextRoot.addEventListener((EventListener)new AkkaStreamServletInitializer());
        contextRoot.addServlet(extensionApiServletHolder, "/api/*");
        contextRoot.addFilter(new FilterHolder((Filter)new AcceptHeaderConditionalFilter((Filter)new ShallowEtagHeaderFilter(), "application/json")), "/deployit/metadata/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(NoCacheFilter.class, "/", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(CharacterEncodingFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameters((Map)new HashMap<String, String>(){
            {
                this.put("encoding", Charsets.UTF_8.name());
                this.put("forceEncoding", "true");
            }
        });
        this.addDeployDefaultServlet(contextRoot);
    }

    private void setupRest(WebAppContext contextRoot) {
        contextRoot.addEventListener((EventListener)new ResteasyBootstrap());
        contextRoot.addEventListener((EventListener)((Object)new DeploySpringContextLoaderListener()));
        ServletHolder servletHolder = new ServletHolder(DispatcherServlet.class);
        servletHolder.setDisplayName("defaultservlet");
        servletHolder.getInitParameters().put(SPRING_CTX_CFG_LOCATION_KEY, "classpath:spring/deployit-spring-web.xml");
        servletHolder.setInitOrder(1);
        ServletHolder servletCsrfHolder = new ServletHolder(DispatcherServlet.class);
        servletCsrfHolder.setDisplayName("csrfservlet");
        servletCsrfHolder.getInitParameters().put(SPRING_CTX_CFG_LOCATION_KEY, "classpath:spring/csrf-deployit-spring-web.xml");
        servletCsrfHolder.setInitOrder(1);
        contextRoot.getInitParams().put("resteasy.servlet.mapping.prefix", "/deployit");
        contextRoot.getInitParams().put("resteasy.document.expand.entity.references", "false");
        contextRoot.getInitParams().put("contextClass", XLWebApplicationContext.class.getName());
        contextRoot.addServlet(servletHolder, "/deployit/*");
        contextRoot.setResourceBase(".");
        contextRoot.addServlet(servletCsrfHolder, "/xldeploy/*");
    }

    private void addDeployDefaultServlet(WebAppContext context) {
        Assert.notNull((Object)context, (String)"Context must not be null");
        ServletHolder holder = new ServletHolder();
        holder.setName("default");
        holder.setServlet((Servlet)new ClassPathResourceContentServlet("web"));
        holder.setInitParameter("dirAllowed", "false");
        holder.setInitOrder(1);
        context.getServletHandler().addServletWithMapping(holder, "/");
        context.getServletHandler().getServletMapping("/").setDefault(true);
    }
}

