/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class AcceptHeaderConditionalFilter
implements Filter {
    private final Filter delegate;
    private final String acceptHeaderValue;

    public AcceptHeaderConditionalFilter(Filter delegate, String acceptHeaderValue) {
        this.delegate = delegate;
        this.acceptHeaderValue = acceptHeaderValue;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.delegate.init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.hasAcceptHeaderValue((HttpServletRequest)request)) {
            this.delegate.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean hasAcceptHeaderValue(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("Accept");
        while (headers.hasMoreElements()) {
            if (!((String)headers.nextElement()).startsWith(this.acceptHeaderValue)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        this.delegate.destroy();
    }
}

