/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=1)
public class BeforeLicenseCheckFilter
extends OncePerRequestFilter {
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (response instanceof HttpServletResponse) {
            response = new RedirectResponseWrapper((HttpServletResponse)response);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        String path = request.getRequestURI();
        return "/productregistration".equals(path);
    }

    private class RedirectResponseWrapper
    extends HttpServletResponseWrapper {
        public static final String PRODUCT_REGISTRATION_PAGE = "productregistration";

        public RedirectResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int sc, String msg) throws IOException {
            if (402 == sc) {
                super.sendRedirect(PRODUCT_REGISTRATION_PAGE);
            } else {
                super.sendError(sc, msg);
            }
        }
    }
}

