/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class LicenseExpiryCheckFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(LicenseExpiryCheckFilter.class);
    private LicenseService licenseService;
    private Integer daysBeforeWarning;

    public LicenseExpiryCheckFilter(LicenseService licenseService, Integer daysBeforeWarning) {
        this.licenseService = licenseService;
        this.daysBeforeWarning = daysBeforeWarning;
    }

    public void init(FilterConfig filterConfig) {
        logger.trace("Added LicenseExpiryCheckFilter to the mix.");
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext((Object)this);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean licenseExpiringSoon;
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            return;
        }
        License license = this.licenseService.getLicense();
        Period validPeriod = this.licenseService.getValidPeriod();
        Authentication authentication = Permissions.getAuthentication();
        boolean hasAuthentication = null != authentication;
        boolean bl = licenseExpiringSoon = validPeriod.getDays() < this.daysBeforeWarning;
        if (hasAuthentication && PermissionHelper.isCurrentUserAdmin() && licenseExpiringSoon) {
            ((HttpServletResponse)response).setHeader("LICENSE-EXPIRY-DATE", license.getStringValue(LicenseProperty.EXPIRES_AFTER));
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

