package com.xebialabs.deployit.plugins

import com.xebialabs.deployit.booter.local.PluginVersions
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.plugin.manager.startup.PluginUpgrader
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

@Component
class DeployitRepeatingPluginUpgrader(pluginUpgrader: PluginUpgrader) extends Upgrade with Logging{
  override def doUpgrade(): Boolean = {
    pluginUpgrader.upgradePlugins()
    info("Plugins upgraded")
    true
  }

  override def upgradeVersion(): Version = Version.valueOf("deployit", PluginVersions.getVersionFor("deployit"))
}
