package com.xebialabs.deployit;

import com.xebialabs.deployit.checks.Checks;

import javax.servlet.*;
import java.io.IOException;

public class RootPageForwardFilter implements Filter {

    public static final String FORWARD_TARGET_PARAM = "ForwardTarget";

    private String target;

    @Override
    public void init(final FilterConfig filterConfig) throws ServletException {
        target = filterConfig.getInitParameter(FORWARD_TARGET_PARAM);
        Checks.checkNotNull(target, FORWARD_TARGET_PARAM);
    }

    @Override
    public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        request.getRequestDispatcher(target).forward(request, response);
    }

    @Override
    public void destroy() {
        // nothing to do.
    }
}
