package com.xebialabs.deployit

import com.xebialabs.deployit.configuration.system.SystemValues
import com.xebialabs.deployit.core.config.SqlConfiguration
import com.xebialabs.deployit.plugins.PluginManagerConfiguration
import com.xebialabs.plugin.manager.cli.PluginManagerCli
import com.xebialabs.plugin.manager.cli.PluginManagerCliLaunchOptions.parseCommandLine
import com.xebialabs.plugin.manager.metadata.Version
import com.xebialabs.plugin.manager.metadata.XLProduct.XLDeploy
import com.xebialabs.plugin.manager.repository.sql.SqlPluginRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.autoconfigure.EnableAutoConfiguration
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration
import org.springframework.boot.{CommandLineRunner, SpringApplication, WebApplicationType}
import org.springframework.context.annotation.{Bean, Configuration, Import}

object PluginManagerCliBootstrapper {

  def main(args: Array[String]): Unit = {
    SystemValues.apply()
    ApplicationBooter.bootPluginManagerCli(Array())

    val cliApp = new SpringApplication(classOf[PluginManagerCliBootstrapper])
    cliApp.setBanner(new XLDeployBanner)
    cliApp.setAllowBeanDefinitionOverriding(true)
    cliApp.setWebApplicationType(WebApplicationType.NONE)
    cliApp.run(args: _*)
  }

}

@Configuration
@EnableAutoConfiguration(
  exclude = Array(
    classOf[DataSourceAutoConfiguration]
  )
)
@Import(
  Array(
    classOf[PluginManagerConfiguration],
    classOf[SqlConfiguration]
  )
)
class PluginManagerCliBootstrapper extends CommandLineRunner {

  @Autowired
  var sqlPluginRepository: SqlPluginRepository = _

  @Autowired
  var pluginManagerCli: PluginManagerCli = _

  @Bean
  def pluginManagerCli(pluginRepository: SqlPluginRepository) = new PluginManagerCli(pluginRepository, XLDeploy, Version.zero.id)

  override def run(args: String*): Unit = {
    val cliLaunchOptions = parseCommandLine(args.toArray)
    if (cliLaunchOptions != null) {
      val output = pluginManagerCli.run(cliLaunchOptions)
      println(output)
    }

    System.exit(0)
  }
}
