package com.xebialabs.deployit.server.jmx

import ai.digital.deploy.jmx.{JMXAgent, JMXSettings}
import com.xebialabs.deployit.server.jmx.KamonJmxToolkit.{DEPLOY_JMX_KEY, KAMON_KEY}
import com.xebialabs.xlplatform.config.ConfigurationHolder
import grizzled.slf4j.Logging
import kamon.Kamon
import org.springframework.context.annotation.DependsOn
import org.springframework.stereotype.Component

import javax.annotation.PostConstruct

object KamonJmxToolkit {
  private val DEPLOY_JMX_KEY = "deploy.jmx"
  private val KAMON_KEY = "kamon"
}

@DependsOn(Array("configurationHolderInitilizer"))
@Component
class KamonJmxToolkit extends Logging {

  @PostConstruct
  def initializeJMXAgent(): Unit = {
    val config = ConfigurationHolder.get()
    val jmxSettings = new JMXSettings(config)
    new JMXAgent().start(jmxSettings)
    if (jmxSettings.enabled) {
      logger.info("Initialising JMX agent")
      val deployJmxConfig = config.getConfig(DEPLOY_JMX_KEY)
      val defaultKamonConfig = config.withOnlyPath(KAMON_KEY)
      val kamonConfig = if (deployJmxConfig.hasPath(KAMON_KEY))
        deployJmxConfig.withOnlyPath(KAMON_KEY).withFallback(defaultKamonConfig)
      else
        defaultKamonConfig

      Kamon.init(kamonConfig)
    }
  }
}
