package com.xebialabs.deployit

import com.xebialabs.deployit.core.auth.LoginMetadataService
import com.xebialabs.deployit.security.RoleService
import jakarta.servlet.http.HttpServletResponse.SC_FORBIDDEN
import jakarta.servlet.http.{HttpServletRequest, HttpServletResponse}
import org.joda.time.LocalDate
import org.springframework.security.access.AccessDeniedException
import org.springframework.security.core.context.SecurityContextHolder
import org.springframework.security.web.access.AccessDeniedHandler
import org.springframework.util.MimeTypeUtils

import scala.jdk.CollectionConverters._

class MissingLoginPermissionErrorHandler(loginMetadataService: LoginMetadataService, roleService: RoleService)
  extends AccessDeniedHandler {

  def acceptsHtml(request: HttpServletRequest): Boolean = request.getHeaders("Accept").asScala.contains("text/html")

  override def handle(request: HttpServletRequest, response: HttpServletResponse, accessDeniedException: AccessDeniedException): Unit = {
    val loginMetadata = loginMetadataService.getLoginMetadata
    val authentication = SecurityContextHolder.getContext.getAuthentication
    val roles = roleService.getRolesFor(authentication, null, null, null)

    response.setStatus(SC_FORBIDDEN)
    response.setContentType(MimeTypeUtils.TEXT_HTML_VALUE)

    StaticPageHelper.writeStaticPage(response.getWriter,
      "login-permission-not-granted.html",
      "username" -> loginMetadata.username,
      "hasRoles" -> (!roles.isEmpty).asInstanceOf[Object],
      "currentRoles" -> roles.asScala.map(_.getName).mkString(", "),
      "loginOptions" -> loginMetadata.loginProviders,
      "copyrightYear" -> new LocalDate().getYear.asInstanceOf[Object]
    )
  }
}
