package com.xebialabs.deployit

import jakarta.servlet.http.HttpServletResponse.{SC_FORBIDDEN, SC_NOT_FOUND}
import org.eclipse.jetty.server.{Request, Response}
import org.joda.time.LocalDate

import java.io.{IOException, Writer}

class RootPageMissingErrorHandler(val welcomePage: String) extends HttpErrorHandler
{
  private def indexPage = Option(welcomePage).getOrElse("/index.html")

  override def canHandle(request: Request, code: Int): Boolean = {
    val requestURI: String = request.getHttpURI.getPath;
    val contextPath = request.getContext.getContextPath;
    val servletPath = requestURI.substring(contextPath.length)
    (code == SC_FORBIDDEN || code == SC_NOT_FOUND) && "" == servletPath ||
      // previous version would respond to "/index.html" with Flex UI as well, now that could result in NOT_FOUND (404)
      // also respond to configurable welcome page.
      code == SC_NOT_FOUND && indexPage == servletPath
  }

  override def changeResponse(response: Response): Unit = response.setStatus(200)

  @throws[IOException]
  override def writeErrorContent(writer: Writer): Unit = StaticPageHelper.writeStaticPage(writer,
    "root-page-missing.html",
    "copyrightYear" -> new LocalDate().getYear.asInstanceOf[Object],
    "welcomePage" -> welcomePage
  )
}
