package com.xebialabs.deployit.config

import com.fasterxml.jackson.databind.{Module, SerializationFeature}
import com.fasterxml.jackson.datatype.joda.JodaModule
import com.fasterxml.jackson.module.scala.DefaultScalaModule
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class XldJacksonConfiguration {

  @Bean
  def scalaModule: Module = new DefaultScalaModule

  @Bean
  def jodaModule: Module = new JodaModule

  def jsonCustomizer: Jackson2ObjectMapperBuilderCustomizer =
    builder =>  builder.featuresToDisable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)

}
