package com.xebialabs.deployit.plugins

import com.xebialabs.deployit.server.api.upgrade.{ApplicableRepoTypes, RepoType, RepositoryInitialization}
import com.xebialabs.plugin.manager.startup.PluginInserter
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

@ApplicableRepoTypes(Array(RepoType.SQL))
class PluginsRepositoryInitializer(@Autowired val pluginsInserter: PluginInserter) extends RepositoryInitialization with Logging {

  override def doInitialize(): Unit = {
    info("inserting all plugins from plugins folder into database")
    pluginsInserter.insertAllPluginsFromFsIntoDb()
  }

  override def getComponent = "deployit"
}
