package com.xebialabs.deployit;

import jakarta.servlet.*;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Enumeration;

public class AcceptHeaderConditionalFilter implements Filter {

    private final Filter delegate;
    private final String acceptHeaderValue;

    public AcceptHeaderConditionalFilter(Filter delegate, String acceptHeaderValue) {
        this.delegate = delegate;
        this.acceptHeaderValue = acceptHeaderValue;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        delegate.init(filterConfig);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (hasAcceptHeaderValue((HttpServletRequest)request)) {
            delegate.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean hasAcceptHeaderValue(HttpServletRequest request) {
        Enumeration<String> headers = request.getHeaders("Accept");
        while (headers.hasMoreElements()) {
            if (headers.nextElement().startsWith(acceptHeaderValue))
                return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        delegate.destroy();
    }
}
