package com.xebialabs.deployit.server.jetty;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.stream.Collectors;

@Configuration
public class CustomJettyConfiguration {
    @Bean
    JettyServletWebServerFactory jettyServletWebServerFactory(
            ObjectProvider<JettyServerCustomizer> serverCustomizers) {
        JettyServletWebServerFactory factory = new DeployJettyServletWebServerFactory();
        factory.getServerCustomizers().addAll(serverCustomizers.orderedStream().collect(Collectors.toList()));
        return factory;
    }
}
