package com.xebialabs.deployit.service;


import com.xebialabs.deployit.service.deployment.DeployedProcessorsFactory;
import com.xebialabs.deployit.service.deployment.DeployedService;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.service.validation.Validator;

import java.util.concurrent.atomic.AtomicReference;

public class DeployServicesHolder {
    private static final AtomicReference<DeployServicesHolder> GLOBAL = new AtomicReference<>();

    private final DeployedService deployedService;
    private final DeploymentService deploymentService;
    private final Validator validator;
    private final DeployedProcessorsFactory deployedProcessorsFactory;

    public DeployServicesHolder(DeployedService deployedService, DeploymentService deploymentService, Validator validator, DeployedProcessorsFactory deployedProcessorsFactory) {
        this.deployedService = deployedService;
        this.deploymentService = deploymentService;
        this.validator = validator;
        this.deployedProcessorsFactory = deployedProcessorsFactory;
    }

    public DeployedService getDeployedService() {
        return deployedService;
    }

    public DeploymentService getDeploymentService() {
        return deploymentService;
    }

    public Validator getValidator() {
        return validator;
    }

    public DeployedProcessorsFactory getDeployedProcessorsFactory() {
        return deployedProcessorsFactory;
    }

    public static DeployServicesHolder initializeGlobalInstance(DeployedService deployedService, DeploymentService deploymentService, Validator validator, DeployedProcessorsFactory deployedProcessorsFactory) {
        GLOBAL.set(new DeployServicesHolder(deployedService, deploymentService, validator, deployedProcessorsFactory));
        return getGlobalInstance();
    }

    public static DeployServicesHolder getGlobalInstance() {
        return GLOBAL.get();
    }

}
