/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoCacheFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(NoCacheFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.trace("Added NoCacheFilter to the mix.");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        httpResponse.setHeader("Pragma", "no-cache");
        httpResponse.setDateHeader("Expires", 0L);
        chain.doFilter(request, (ServletResponse)httpResponse);
    }

    public void destroy() {
    }
}

