package com.xebialabs.deployit.core.rest.test.api

import jakarta.ws.rs.core.Response
import jakarta.ws.rs.{POST, Path, PathParam}
import _root_.datasets.{ExporterPerformanceSet, ReportsPerformanceSet, RepositoryPerformanceSet, RiaTestSet}
import com.xebialabs.deployit.rest.test.api.DataSet
import com.xebialabs.deployit.rest.test.api.datasets.{CiExplorerSet, DemoSet, SampleSet}
import datasets.ciexplorer.{CiExplorerSet1, CiExplorerSet2}
import org.springframework.stereotype.Controller

@Controller
@Path("/generate")
class DataGenerator() {
  val dataSets =
    Set(SampleSet, RiaTestSet, DemoSet, RepositoryPerformanceSet, ExporterPerformanceSet, CiExplorerSet, CiExplorerSet1, CiExplorerSet2, ReportsPerformanceSet)

  val sets: Map[String, DataSet] = dataSets.map { s: DataSet =>
    (s.name(), s)
  }.toMap

  @POST
  @Path("/{set}")
  def generate(@PathParam("set") dataSet: String): Response =
    generate(dataSet, null)

  @POST
  @Path("/{set}/{args:.*}")
  def generate(@PathParam("set") dataSet: String, @PathParam("args") args: String): Response = {
    def testArgs: List[String] = Option(args).map(_.split('/').toList).getOrElse(List())
    sets.get(dataSet) match {
      case None => Response.serverError().entity(s"No data set found by name $dataSet").build()
      case Some(x) =>
        x.generateSet(testArgs)
        x.shutdown()
        Response.noContent().build()
    }
  }
}
