/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support.utils;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.test.support.onthefly.EarOnTheFly;
import com.xebialabs.deployit.test.support.onthefly.WarOnTheFly;
import com.xebialabs.deployit.test.support.utils.DebugStepExecutionContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Servlet;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.springframework.core.io.Resource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItestUtils {
    public static final String ITEST_EAR_NAME = "itest-ear";
    public static final String ITEST_WAR_NAME = "itest";
    public static final String ITEST_SUCCESS_MESSAGE = "The itest has succeeded!";
    private static StepExecutionContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File resourceToFile(Resource resource) throws IOException {
        File resourceTempFile = File.createTempFile("junit-resource", "dat");
        resourceTempFile.deleteOnExit();
        FileOutputStream tempFileOut = new FileOutputStream(resourceTempFile);
        try {
            File file;
            InputStream resourceIn = resource.getInputStream();
            try {
                IOUtils.copy((InputStream)resourceIn, (OutputStream)tempFileOut);
                file = resourceTempFile;
            }
            catch (Throwable throwable) {
                resourceIn.close();
                throw throwable;
            }
            resourceIn.close();
            return file;
        }
        finally {
            ((OutputStream)tempFileOut).close();
        }
    }

    public static Ear createItestEar(Class<? extends Servlet> itestServletClass) throws IOException {
        WarOnTheFly wotf = new WarOnTheFly(ITEST_WAR_NAME);
        wotf.addServlet(itestServletClass);
        EarOnTheFly eotf = new EarOnTheFly(ITEST_EAR_NAME);
        eotf.addWarOnTheFly(wotf);
        Ear itestEar = new Ear();
        itestEar.setLabel(eotf.getName());
        itestEar.setName(eotf.getName());
        itestEar.setLocation(eotf.writeToTemporaryFile().getPath());
        return itestEar;
    }

    public static War createItestWar(Class<? extends Servlet> itestServletClass) throws IOException {
        WarOnTheFly wotf = new WarOnTheFly(ITEST_WAR_NAME);
        wotf.addServlet(itestServletClass);
        War warCi = new War();
        warCi.setLabel(wotf.getName());
        warCi.setName(wotf.getName());
        warCi.setLocation(wotf.writeToTemporaryFile().getPath());
        return warCi;
    }

    public static void assertItestServletSucceeds(Host serverHost, int port, Class<? extends Servlet> itestServletClass) throws IOException, SAXException {
        ItestUtils.assertItestServletSucceeds(serverHost, port, itestServletClass, null);
    }

    public static void assertItestServletSucceeds(Host serverHost, int port, Class<? extends Servlet> itestServletClass, String action) throws IOException, SAXException {
        String url = "http://" + serverHost.getAddress() + ":" + port + "/" + ITEST_WAR_NAME + "/" + itestServletClass.getSimpleName();
        if (action != null) {
            url = url + "?action=" + action;
        }
        WebConversation wc = new WebConversation();
        GetMethodWebRequest req = new GetMethodWebRequest(url);
        WebResponse resp = wc.getResponse((WebRequest)req);
        String responseText = resp.getText();
        Assert.assertTrue((boolean)responseText.contains(ITEST_SUCCESS_MESSAGE));
    }

    public static void assertStepSucceeds(Step step) {
        ItestUtils.assertStepReturns(step, true);
    }

    public static void assertStepFails(Step step) {
        ItestUtils.assertStepReturns(step, false);
    }

    public static StepExecutionContext getDebugStepExecutionContext() {
        if (context == null) {
            context = new DebugStepExecutionContext();
        }
        return context;
    }

    public static void clearStepExecutionContext() {
        if (context != null) {
            ((DebugStepExecutionContext)context).destroy();
            context = null;
        }
    }

    public static void assertStepReturns(Step step, boolean expectedReturnValue) {
        boolean actualReturnValue = step.execute(ItestUtils.getDebugStepExecutionContext());
        Assert.assertEquals((String)("Step " + step.getDescription() + " did not complete with the expected state"), (Object)expectedReturnValue, (Object)actualReturnValue);
    }
}

