package com.xebialabs.deployit.test.support.stubs;

import java.io.Serializable;

import com.xebialabs.deployit.Change;

public class StubChange<T extends Serializable> implements Change<T> {

	Class<T> ciClass;

	T oldRevision;

	T newRevision;

	@SuppressWarnings("unchecked")
	public StubChange(T oldRevision, T newRevision) {
		this.oldRevision = oldRevision;
		this.newRevision = newRevision;
		if (this.oldRevision != null) {
			ciClass = (Class<T>) this.oldRevision.getClass();
		} else if (this.newRevision != null) {
			ciClass = (Class<T>) this.newRevision.getClass();
		} else {
			throw new IllegalArgumentException("oldRevision and newRevision are both null");
		}
	}

	public boolean isAddition() {
		return oldRevision == null && newRevision != null;
	}

	public boolean isDeletion() {
		return oldRevision != null && newRevision == null;
	}

	public boolean isModification() {
		return oldRevision != null && newRevision != null;
	}

	public Class<T> getConfigurationItemClass() {
		return ciClass;
	}

	public String getConfigurationItemType() {
		return ciClass.getName();
	}

	public T getNewRevision() {
		return newRevision;
	}

	public T getOldRevision() {
		return oldRevision;
	}

	public String toString() {
		return "StubChange from " + oldRevision + " to " + newRevision;
	}
}
