package com.xebialabs.deployit.test.support.stubs;

import java.io.Serializable;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

@SuppressWarnings("serial")
@ConfigurationItem
public class StubConfigurationItem implements Serializable {
	@ConfigurationItemProperty
	private boolean booleanProperty;
	
	@ConfigurationItemProperty
	private String stringProperty;
	
	@ConfigurationItemProperty
	private int intProperty;
	
	private static enum EnumValues { ONE, TWO, THREE }
	
	@ConfigurationItemProperty
	private EnumValues enumProperty;
	
	private StubConfigurationItem(boolean booleanProperty, String stringProperty, 
			int intProperty, EnumValues enumProperty) {
		this.booleanProperty = booleanProperty;
		this.stringProperty = stringProperty;
		this.intProperty = intProperty;
		this.enumProperty = enumProperty;
	}

	public boolean isBooleanProperty() {
		return booleanProperty;
	}

	public String getStringProperty() {
		return stringProperty;
	}

	public int getIntProperty() {
		return intProperty;
	}

	public EnumValues getEnumProperty() {
		return enumProperty;
	}

	public void setBooleanProperty(boolean booleanProperty) {
		this.booleanProperty = booleanProperty;
	}

	public void setStringProperty(String stringProperty) {
		this.stringProperty = stringProperty;
	}

	public void setIntProperty(int intProperty) {
		this.intProperty = intProperty;
	}

	public void setEnumProperty(EnumValues enumProperty) {
		this.enumProperty = enumProperty;
	}
}
