/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support.onthefly;

import com.xebialabs.deployit.test.support.onthefly.JarOnTheFly;
import com.xebialabs.deployit.test.support.onthefly.WarOnTheFly;
import com.xebialabs.deployit.test.support.utils.VelocityUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class EarOnTheFly
extends JarOnTheFly {
    private String name;
    private Map<String, String> wars;

    public EarOnTheFly(String name) {
        this.name = name;
        this.wars = new HashMap<String, String>();
    }

    public void addWarOnTheFly(WarOnTheFly wotf) throws IOException {
        String warFilename = wotf.getName() + ".war";
        FileSystemResource warFile = new FileSystemResource(wotf.writeToTemporaryFile());
        this.addFile(warFilename, (Resource)warFile);
        this.wars.put(wotf.getName(), warFilename);
    }

    public File writeToTemporaryFile() throws IOException {
        this.addApplicationXml();
        return this.writeToTemporaryFile(this.name, ".ear");
    }

    private void addApplicationXml() {
        VelocityContext context = new VelocityContext();
        context.put("name", (Object)this.name);
        context.put("wars", this.wars);
        String webxml = VelocityUtils.evaluateTemplate(context, "com/xebialabs/deployit/test/support/onthefly/application.xml.vm");
        this.addFile("META-INF/application.xml", (Resource)new ByteArrayResource(webxml.getBytes()));
    }

    public String getName() {
        return this.name;
    }
}

