/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support.onthefly;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.ci.artifact.ConfigurationFiles;
import com.xebialabs.deployit.ci.artifact.DeployableArtifact;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.Folder;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.SqlScript;
import com.xebialabs.deployit.ci.artifact.StaticContent;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.test.support.onthefly.EarOnTheFly;
import com.xebialabs.deployit.test.support.onthefly.JarOnTheFly;
import com.xebialabs.deployit.test.support.onthefly.WarOnTheFly;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DarOnTheFly
extends JarOnTheFly {
    protected static final String DAR_EXTENSION = ".zip";
    private static final String PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME = "Deployit-Package-Format-Version";
    private static final String PACKAGE_FORMAT_VERSION_NUMBER = "1.1";
    private static final String APPLICATION_ATTRIBUTE_NAME = "Ci-Application";
    private static final String VERSION_ATTRIBUTE_NAME = "Ci-Version";
    private static final String TYPE_ATTRIBUTE_NAME = "Ci-Type";
    private static final String NAME_ATTRIBUTE_NAME = "Ci-Name";
    private static final String JEE_ARTIFACT_DIRECTORY_NAME = "enterprisearchive";
    private static final String CONFIGURATION_FILES_DIRECTORY_NAME = "appconfig";
    private static final String STATIC_CONTENT_DIRECTORY_NAME = "staticcontent";
    private static final String SQL_SCRIPT_DIRECTORY_NAME = "sql";
    private final Map<String, FolderConfigurationItem> folders = Maps.newHashMapWithExpectedSize((int)2);

    public DarOnTheFly(String applicationName, String version) {
        super(applicationName + '-' + version);
        this.addManifestMainAttribute(PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME, PACKAGE_FORMAT_VERSION_NUMBER);
        this.addManifestMainAttribute(APPLICATION_ATTRIBUTE_NAME, applicationName);
        this.addManifestMainAttribute(VERSION_ATTRIBUTE_NAME, version);
        this.folders.put(CONFIGURATION_FILES_DIRECTORY_NAME, new FolderConfigurationItem(ConfigurationFiles.class, CONFIGURATION_FILES_DIRECTORY_NAME));
        this.folders.put(STATIC_CONTENT_DIRECTORY_NAME, new FolderConfigurationItem(StaticContent.class, STATIC_CONTENT_DIRECTORY_NAME));
    }

    public DarOnTheFly addDeployableArtifact(Class<? extends DeployableArtifact> configurationItemType, String filename, Resource resource) {
        this.addFile(filename, resource, DarOnTheFly.makeAttributes(configurationItemType, null));
        return this;
    }

    private static Map<String, String> makeAttributes(Class<? extends DeployableArtifact> configurationItemType, String name) {
        boolean hasName = name != null;
        HashMap attributes = Maps.newHashMapWithExpectedSize((int)(hasName ? 2 : 1));
        attributes.put(TYPE_ATTRIBUTE_NAME, configurationItemType.getSimpleName());
        if (hasName) {
            attributes.put(NAME_ATTRIBUTE_NAME, name);
        }
        return attributes;
    }

    public DarOnTheFly addNamedDeployableArtifact(String name, Class<? extends NamedDeployableArtifact> configurationItemType, String filename, Resource resource) {
        this.addFile(filename, resource, DarOnTheFly.makeAttributes(configurationItemType, name));
        return this;
    }

    public DarOnTheFly addWarOnTheFly(WarOnTheFly war) throws IOException {
        return this.addJeeArtifactOnTheFly(War.class, war, ".war");
    }

    public DarOnTheFly addEarOnTheFly(EarOnTheFly ear) throws IOException {
        return this.addJeeArtifactOnTheFly(Ear.class, ear, ".ear");
    }

    private DarOnTheFly addJeeArtifactOnTheFly(Class<? extends NamedDeployableArtifact> configurationItemType, JarOnTheFly artifact, String artifactExtension) throws IOException {
        String artifactFilename = artifact.getName() + artifactExtension;
        this.addNamedDeployableArtifact(artifact.getName(), configurationItemType, "enterprisearchive/" + artifactFilename, (Resource)new FileSystemResource(artifact.writeToTemporaryFile()));
        return this;
    }

    public DarOnTheFly addConfigurationFile(String filename, Resource resource) {
        this.folders.get(CONFIGURATION_FILES_DIRECTORY_NAME).addEntry(filename, resource);
        return this;
    }

    public DarOnTheFly addStaticContent(String filename, Resource resource) {
        this.folders.get(STATIC_CONTENT_DIRECTORY_NAME).addEntry(filename, resource);
        return this;
    }

    @Override
    public File writeToTemporaryFile() throws IOException {
        this.addFolders();
        return this.writeToTemporaryFile(this.name, DAR_EXTENSION);
    }

    private void addFolders() {
        for (FolderConfigurationItem folder : this.folders.values()) {
            if (folder.isEmpty()) continue;
            folder.addToDar();
        }
    }

    public DarOnTheFly addSqlScript(String sqlScriptname, Resource sqlScript) {
        return this.addDeployableArtifact(SqlScript.class, "sql/" + sqlScriptname, sqlScript);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FolderConfigurationItem {
        private final Class<? extends Folder> type;
        private final String dirname;
        private final Map<String, Resource> entries = Maps.newHashMap();

        private FolderConfigurationItem(Class<? extends Folder> type, String dirname) {
            this.type = type;
            this.dirname = dirname;
        }

        private void addEntry(String filename, Resource resource) {
            this.entries.put(filename, resource);
        }

        private boolean isEmpty() {
            return this.entries.isEmpty();
        }

        private void addToDar() {
            DarOnTheFly.this.addManifestDirectoryAttributes(this.dirname, DarOnTheFly.makeAttributes(this.type, null));
            for (Map.Entry<String, Resource> entry : this.entries.entrySet()) {
                DarOnTheFly.this.addFile(this.dirname + '/' + entry.getKey(), entry.getValue());
            }
        }
    }
}

