/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support.deployment.tester;

import com.xebialabs.deployit.test.support.deployment.tester.DeployedItemTester;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Session;
import javax.naming.InitialContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMailTester
extends DeployedItemTester {
    Logger logger = Logger.getLogger(JavaMailTester.class.getName());

    public JavaMailTester(Map<String, String> testParams) {
        super(testParams);
    }

    @Override
    public boolean testDeployedItem() {
        return this.checkMailSession();
    }

    private boolean checkMailSession() {
        try {
            InitialContext ic = new InitialContext();
            Session session = (Session)ic.lookup((String)this.testParams.get("jndiName"));
            if (session == null) {
                this.logger.log(Level.INFO, "Mail session retrieved is NULL");
                return false;
            }
            return this.assertMailSessionProperties(session);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean assertMailSessionProperties(Session session) {
        this.printPropertiesForDebugPurpose(session.getProperties());
        for (Map.Entry eachTestParam : this.testParams.entrySet()) {
            String key = (String)eachTestParam.getKey();
            if (!key.startsWith("property.")) continue;
            key = key.substring("property.".length());
            this.logger.log(Level.INFO, "key from testParam is:" + key);
            String expectedValue = (String)eachTestParam.getValue();
            if (expectedValue.equals(session.getProperty(key))) continue;
            this.logger.log(Level.INFO, "expected " + expectedValue + ", got " + session.getProperty(key));
            return false;
        }
        return true;
    }

    private void printPropertiesForDebugPurpose(Properties properties) {
        for (Map.Entry<Object, Object> eachEntry : properties.entrySet()) {
            this.logger.log(Level.INFO, "session property key:" + eachEntry.getKey() + ", value:" + eachEntry.getValue());
        }
    }
}

