/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support.onthefly;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.test.support.onthefly.JarOnTheFly;
import com.xebialabs.deployit.test.support.utils.VelocityUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.velocity.VelocityContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarOnTheFly
extends JarOnTheFly {
    protected static final String WAR_EXTENSION = ".war";
    private final Map<String, String> servlets = Maps.newHashMap();

    public WarOnTheFly(String name) {
        super(name);
    }

    public WarOnTheFly addServlet(Class<? extends Servlet> servletClass) {
        String servletName = servletClass.getSimpleName();
        String servletClassFilename = servletClass.getName().replace('.', '/') + ".class";
        this.addFile("WEB-INF/classes/" + servletClassFilename, (Resource)new ClassPathResource(servletClassFilename));
        this.servlets.put(servletName, servletClass.getName());
        return this;
    }

    public WarOnTheFly addClass(Class<?> theClass) {
        String theClassFileName = theClass.getName().replace('.', '/') + ".class";
        this.addFile("WEB-INF/classes/" + theClassFileName, (Resource)new ClassPathResource(theClassFileName));
        return this;
    }

    @Override
    public File writeToTemporaryFile() throws IOException {
        this.addWebXml();
        return this.writeToTemporaryFile(this.name, WAR_EXTENSION);
    }

    private void addWebXml() {
        VelocityContext context = new VelocityContext();
        context.put("name", (Object)this.name);
        context.put("servlets", this.servlets);
        for (Map.Entry<String, Object> eachContextEntry : this.getAdditionalVelocityContextEntries().entrySet()) {
            context.put(eachContextEntry.getKey(), eachContextEntry.getValue());
        }
        String webxml = VelocityUtils.evaluateTemplate(context, this.getWebXmlTemplatePath());
        this.addFile("WEB-INF/web.xml", (Resource)new ByteArrayResource(webxml.getBytes()));
    }

    protected Map<String, Object> getAdditionalVelocityContextEntries() {
        HashMap contextEntries = Maps.newHashMap();
        return contextEntries;
    }

    protected String getWebXmlTemplatePath() {
        return "com/xebialabs/deployit/test/support/onthefly/web.xml.vm";
    }
}

