/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support.onthefly;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarOnTheFly {
    protected static final String JAR_EXTENSION = ".jar";
    protected final String name;
    private final Map<String, Resource> files = Maps.newHashMap();
    private final ManifestDefinition manifestDefinition = new ManifestDefinition();

    public JarOnTheFly(String name) {
        this.name = name;
    }

    protected void addManifestMainAttribute(String name, String value) {
        this.manifestDefinition.addMainAttribute(name, value);
    }

    protected JarOnTheFly addManifestDirectoryAttributes(String dirname, Map<String, String> manifestAttributes) {
        this.manifestDefinition.addEntryAttributes(dirname, (Map)Preconditions.checkNotNull(manifestAttributes));
        return this;
    }

    public JarOnTheFly addFile(String filename, Resource resource) {
        return this.addFile(filename, resource, null);
    }

    protected JarOnTheFly addFile(String filename, Resource resource, Map<String, String> manifestAttributes) {
        this.files.put(filename, resource);
        if (manifestAttributes != null) {
            this.manifestDefinition.addEntryAttributes(filename, manifestAttributes);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File jarFile) throws IOException {
        FileOutputStream jarFileOut = new FileOutputStream(jarFile);
        try {
            JarOutputStream jarOut = this.manifestDefinition.isEmpty() ? new JarOutputStream(jarFileOut) : new JarOutputStream((OutputStream)jarFileOut, this.manifestDefinition.toManifest());
            try {
                for (Map.Entry<String, Resource> eachFile : this.files.entrySet()) {
                    String filename = eachFile.getKey();
                    Resource resource = eachFile.getValue();
                    jarOut.putNextEntry(new JarEntry(filename));
                    InputStream resourceIn = resource.getInputStream();
                    try {
                        IOUtils.copy((InputStream)resourceIn, (OutputStream)jarOut);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)resourceIn);
                    }
                    jarOut.closeEntry();
                }
            }
            finally {
                IOUtils.closeQuietly((OutputStream)jarOut);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)jarFileOut);
        }
    }

    public File writeToTemporaryFile() throws IOException {
        return this.writeToTemporaryFile(this.name, JAR_EXTENSION);
    }

    protected File writeToTemporaryFile(String prefix, String suffix) throws IOException {
        File tempJarFile = File.createTempFile(prefix, suffix);
        tempJarFile.deleteOnExit();
        this.write(tempJarFile);
        return tempJarFile;
    }

    public String getName() {
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManifestDefinition {
        private static final String GENERATED_MANIFEST_VERSION = "1.0";
        private final ReentrantLock lock = new ReentrantLock();
        private final ConcurrentMap<String, String> mainAttributes = new ConcurrentHashMap<String, String>();
        private final ConcurrentMap<String, Map<String, String>> entryAttributes = new ConcurrentHashMap<String, Map<String, String>>();

        private ManifestDefinition() {
        }

        private ManifestDefinition addMainAttribute(String name, String value) {
            this.mainAttributes.put(name, value);
            return this;
        }

        private ManifestDefinition addEntryAttributes(String entryName, Map<String, String> attributes) {
            this.entryAttributes.putIfAbsent(entryName, new ConcurrentHashMap(((Map)Preconditions.checkNotNull(attributes)).size()));
            ((Map)this.entryAttributes.get(entryName)).putAll(attributes);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isEmpty() {
            this.lock.lock();
            try {
                boolean bl = this.mainAttributes.isEmpty() && this.entryAttributes.isEmpty();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Manifest toManifest() {
            Manifest manifest = new Manifest();
            Attributes manifestMainAttributes = manifest.getMainAttributes();
            manifestMainAttributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), GENERATED_MANIFEST_VERSION);
            Map<String, Attributes> manifestEntries = manifest.getEntries();
            this.lock.lock();
            try {
                for (Map.Entry mainAttribute : this.mainAttributes.entrySet()) {
                    manifestMainAttributes.putValue((String)mainAttribute.getKey(), (String)mainAttribute.getValue());
                }
                for (Map.Entry attributesForEntry : this.entryAttributes.entrySet()) {
                    manifestEntries.put((String)attributesForEntry.getKey(), ManifestDefinition.toAttributes((Map)attributesForEntry.getValue()));
                }
            }
            finally {
                this.lock.unlock();
            }
            return manifest;
        }

        private static Attributes toAttributes(Map<String, String> values) {
            Attributes attributes = new Attributes(values.size());
            for (Map.Entry<String, String> value : values.entrySet()) {
                attributes.putValue(value.getKey(), value.getValue());
            }
            return attributes;
        }
    }
}

