package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.TomcatContextFileUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatDataSource;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;

@SuppressWarnings("serial")
public class DestroyTomcatDataSourceStep extends TomcatStepBase implements Step {

	private TomcatDataSource dataSource;
	
	public DestroyTomcatDataSourceStep(TomcatServer server, TomcatDataSource dataSource, String contextRoot) {
		super(server, contextRoot);
		this.dataSource = dataSource;

		setDescription("Destroy datasource " + dataSource + " on Tomcat server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession hostSession = server.getHost().getHostSession();
		try {
			HostFile contextFile = hostSession.getFile(getContextFilePathOnServer());
			ctx.logOutput("deleting datasouce " + dataSource + " definition from the context file " + contextFile.getPath());
			TomcatContextFileUtils contextFileUtils = new TomcatContextFileUtils(contextFile);
			boolean deletionResult = contextFileUtils.deleteDataSource(dataSource);
			ctx.logOutput("Done.");
			return deletionResult;
		}finally {
			hostSession.close();
		}
	}

}
