package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.plugin.tomcat.TomcatContextFileUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;

@SuppressWarnings("serial")
public class TomcatDeployApplicationStep extends TomcatDeploymentStepBase {

	public TomcatDeployApplicationStep(TomcatServer target, War war) {
		super(target, war, "");
		setDescription("Deploy WAR file " + war + " to Tomcat server " + server);
	}

	public TomcatDeployApplicationStep(TomcatServer target, War war, String contextPath) {
		super(target, war, contextPath);
		setDescription("Deploy WAR file " + war + " to Tomcat server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = server.connectToAdminHost();
		HostFile targetTmpFile;
		try {
			HostSession lhs = HostSessionFactory.getHostSession(Host.getLocalHost());
			try {
				HostFile sourceFile = lhs.getFile(artifact.getLocation());

				String artifactTargetFileName = getArtifactTargetFileName();

				targetTmpFile = rhs.getTempFile(artifactTargetFileName);
				ctx.logOutput("Copying application artifact to " + targetTmpFile.getPath() + " on " + server.getHost());
				HostFileUtils.copyFile(sourceFile, targetTmpFile);

				HostFile targetDeployFile = rhs.getFile(getDeployedArtifactPath());
				ctx.logOutput("Moving application artifact from " + targetTmpFile.getPath() + " to "
						+ targetDeployFile.getPath() + " on " + server.getHost());
				targetTmpFile.moveTo(targetDeployFile);
				
				if(isContextSet()) {
				//create the context file
					HostFile contextFile = rhs.getFile(getContextFilePathOnServer());
					TomcatContextFileUtils contextFileUtils = new TomcatContextFileUtils(contextFile);
					contextFileUtils.addOrUpdateContextPath(server.getAppBase() + server.getHost().getFileSeparator() + artifactTargetFileName);
				}

				ctx.logOutput("Done.");
				return true;
			} finally {
				lhs.close();
			}
		} finally {
			rhs.close();
		}
	}

}
