package com.xebialabs.deployit.plugin.tomcat.step;

import java.io.IOException;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.TomcatManagerAppUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;

@SuppressWarnings("serial")
public class TomcatHttpBasedUnDeployApplicationStep extends TomcatDeploymentStepBase {

	public TomcatHttpBasedUnDeployApplicationStep(TomcatServer oldTarget, War oldSource) {
		this(oldTarget, oldSource, "");
	}

	public TomcatHttpBasedUnDeployApplicationStep(TomcatServer oldTarget, War oldSource, String contextPath) {
		super(oldTarget, oldSource, contextPath);
		setDescription("Undeploy WAR file " + oldSource + " from Tomcat server " + oldTarget
				+ " using manager application");
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = null;
		try {
		rhs = server.getHost().getHostSession();
		TomcatManagerAppUtils managerAppUtils = new TomcatManagerAppUtils(server);
		ctx.logOutput("Undeploying " + getArtifactTargetFileName() + " using manager app url "
				+ managerAppUtils.getBaseUrl());

		// remove the war
		HostFile targetDeployFile = rhs.getFile(getDeployedArtifactPath());
		ctx.logOutput("Removing application artifact from " + targetDeployFile.getPath() + " on "
				+ server.getHost());
		targetDeployFile.delete();
		
		String deploymentResult = "";
		try {
			String contextRootPath = isContextSet()? contextRoot : artifact.getName();
			deploymentResult = managerAppUtils.undeploy(contextRootPath);
			ctx.logOutput(deploymentResult);
		} catch (IOException e) {
			ctx.logError(e.getMessage());
			return false;
		}

		if (deploymentResult.startsWith("OK")) {
			if (isContextSet()) {
					// delete the context file
					HostFile contextFile = rhs.getFile(getContextFilePathOnServer());
					contextFile.delete();
				} 
			}else {
				return false;
			}
			ctx.logOutput("Done.");
			return true;
		}finally {
			rhs.close();
		}

	}

}
