package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;

@SuppressWarnings("serial")
public class TomcatUnDeployApplicationStep extends TomcatDeploymentStepBase {

	public TomcatUnDeployApplicationStep(TomcatServer oldTarget, War oldSource) {
		this(oldTarget, oldSource, "");
	}

	public TomcatUnDeployApplicationStep(TomcatServer oldTarget, War oldSource, String contextPath) {
		super(oldTarget, oldSource, contextPath);
		setDescription("Undeploy WAR file " + oldSource + " from Tomcat server " + oldTarget);
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = server.connectToAdminHost();
		try {

			// remove the war
			HostFile targetDeployFile = rhs.getFile(getDeployedArtifactPath());
			ctx.logOutput("Removing application artifact from " + targetDeployFile.getPath() + " on "
					+ server.getHost());
			targetDeployFile.delete();

			if (!isContextSet()) {
				// remove the exploded war dir
				String explodedWarDirectoryName = getExplodedWarTargetFileName();
				HostFile targetExplodedWar = rhs.getFile(explodedWarDirectoryName);
				ctx.logOutput("Removing application exploded directory " + targetExplodedWar.getPath() + " on "
						+ server.getHost());
				targetExplodedWar.deleteRecursively();
			} else {
				// delete the context file
				HostFile contextFile = rhs.getFile(getContextFilePathOnServer());
				contextFile.delete();
			}

			ctx.logOutput("Done.");
			return true;
		} finally {
			rhs.close();
		}
	}

}
