/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat.ci;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatManagedServerReachabilityTestStep;
import com.xebialabs.deployit.step.HostConnectionStep;

/**
 * A Apache Tomcat server with manager application deployed on it
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "Tomcat Server instance", discoverable = true, category = "middleware")
public class TomcatManagedServer extends TomcatServer {

    @ConfigurationItemProperty(required = true, label = "Manager App URL", description = "URL of the manager app URL, e.g. http://tomcat-6:8080/manager", size = Size.LARGE, discoveryParam = true)
    private String managerAppUrl;

    @ConfigurationItemProperty(required = true, label = "Tomcat manager username", description = "Username to be used for the manager application deployed on tomcat", size = Size.DEFAULT, discoveryParam = true)
    private String managerUsername;

    @ConfigurationItemProperty(required = true, label = "Tomcat manager password", description = "Password to be used for the manager application deployed on tomcat", size = Size.DEFAULT, password = true, discoveryParam = true)
    private String managerPassword;
    
    public boolean isManaged() {
    	return true;
    }

    public HostSession connectToAdminHost() {
        return getHost().getHostSession();
    }

    public String getManagerUsername() {
        return managerUsername;
    }

    public void setManagerUsername(String managerUsername) {
        this.managerUsername = managerUsername;
    }

    public String getManagerPassword() {
        return managerPassword;
    }

    public void setManagerPassword(String managerPassword) {
        this.managerPassword = managerPassword;
    }

    private List<Step> getCheckSteps() {
        List<Step> steps = new ArrayList<Step>();
        steps.add(new HostConnectionStep(getHost()));
        steps.add(new TomcatManagedServerReachabilityTestStep(this));
        return steps;
    }

    public TomcatManagedServer discover(Map<String, Object> info, ChangePlan cp) {
        cp.addSteps(getCheckSteps());
        cp.execute(info);
        return this;
    }

    public TomcatManagedServer discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
        return this;
    }

    public String getManagerAppUrl() {
        return managerAppUrl;
    }

    public void setManagerAppUrl(String managerAppUrl) {
        this.managerAppUrl = managerAppUrl;
    }

}
