/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat.ci;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.ci.*;
import com.xebialabs.deployit.hostsession.HostSession;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SuppressWarnings("serial")
public abstract class TomcatServer extends BaseConfigurationItem implements Discoverable<TomcatServer>, LoadBalancedServerAware, Hosted {

	public static final int DEPLOYMENT_COMPLETION_WAIT_TIME_MILLIS = 3000;
	public static final ArrayList<LoadBalancingProtocol> SUPPORTED_PROTOCOLS = Lists.newArrayList(LoadBalancingProtocol.AJP);

	@ConfigurationItemProperty(required = true, asContainment = true, label = "Tomcat server host", description = "Host on which the Tomcat server is running.")
	private Host host;

	@ConfigurationItemProperty(required = true, discoveryParam = true, size = Size.LARGE, label = "Tomcat installation location", description = "Place where Tomcat is installed such as /opt/apache-tomcat-6.0.24.")
	private String tomcatHome;

	@ConfigurationItemProperty(required = false, description = "AJP Port for the Tomcat Server, default is 8009")
	private int ajpPort = 8009;

	@ConfigurationItemProperty(required = false, discoveryParam = true, label = "Tomcat appBase", description = "Tomcat appBase, ex webapps")
	private String appBase = "webapps";

	@ConfigurationItemProperty(required = false, discoveryParam = true, label = "Tomcat service", description = "Tomcat service, ex Catalina")
	private String service = "Catalina";

	public abstract TomcatServer discover(Map<String, Object> info, ChangePlan cp);

	public abstract TomcatServer discoverChildrenInfo(Map<String, Object> info, ChangePlan cp);

	public abstract boolean isManaged();

	public HostSession connectToAdminHost() {
		return getHost().getHostSession();
	}

	public String getDeployDirPath() {
		String fileSep = getHost().getFileSeparator();
		return getTomcatHome() + fileSep + appBase;
	}

	public String getContextWithoutVirtualHostDirPath() {
		String fileSep = getHost().getFileSeparator();
		return getTomcatHome() + fileSep + "conf" + fileSep + service + fileSep + "localhost";
	}

	public String getContextWithVirtualHostDirPath(String virtualHostName) {
		String fileSep = getHost().getFileSeparator();
		return getTomcatHome() + fileSep + "conf" + fileSep + service + fileSep + virtualHostName;
	}

	public Host getHost() {
		return host;
	}

	public void setHost(Host host) {
		this.host = host;
	}

	public String getTomcatHome() {
		return tomcatHome;
	}

	public void setTomcatHome(String tomcatHome) {
		this.tomcatHome = tomcatHome;
	}

	public int getAjpPort() {
		return (ajpPort == 0 ? 8009 : ajpPort);
	}

	public void setAjpPort(int ajpPort) {
		this.ajpPort = ajpPort;
	}

	public String getTomcatLibDirectory() {
		String fileSep = getHost().getFileSeparator();
		return getTomcatHome() + fileSep + "lib";
	}

	public String getAppBase() {
		return appBase;
	}

	public void setAppBase(String appBase) {
		this.appBase = appBase;
	}

	public String getService() {
		return service;
	}

	public void setService(String service) {
		this.service = service;
	}

	public List<LoadBalancingProtocol> getSupportedProtocols() {
		return SUPPORTED_PROTOCOLS;
	}

	public List<ListenServer> getLoadBalancedServers(LoadBalancingProtocol protocol) {
		switch (protocol) {
		case AJP:
			final ListenServer server = new ListenServer();
			server.setLabel(getLabel());
			server.setHost(getHost());
			server.setListenPort(getAjpPort());
			return Lists.newArrayList(server);
		default:
			return Lists.newArrayList();
		}
	}

	protected static Logger logger = Logger.getLogger(TomcatServer.class);
}
