/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat.ci;

import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatUnmanagedServerReachabilityTestStep;
import com.xebialabs.deployit.step.CheckDirExistsStep;
import com.xebialabs.deployit.step.CheckFileExistenceStep;
import com.xebialabs.deployit.step.HostConnectionStep;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * A Apache Tomcat server without the manager application installed
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "Tomcat Server instance", discoverable = true, category = "middleware")
public class TomcatUnmanagedServer extends TomcatServer {

	@ConfigurationItemProperty(required = true, label = "Base URL of the server", description = "The base URL which will be used to check whether server is running, e.g. http://tomcat-6:8080", discoveryParam = true)
	private String baseUrl;

	@ConfigurationItemProperty(required = true, label = "Tomcat start command", description = "Command that should be executed to start the Tomcat server, e.g./opt/tomcat/bin/catalina.sh start.", size = Size.LARGE, discoveryParam = true)
	private String startCommand;

	@ConfigurationItemProperty(required = true, label = "Tomcat stop command", description = "Command that should be executed to stop the Tomcat server, e.g. /opt/tomat/bin/catalina.sh stop", size = Size.LARGE, discoveryParam = true)
	private String stopCommand;

    public boolean isManaged() {
    	return false;
    }

	public HostSession connectToAdminHost() {
		return getHost().getHostSession();
	}

	public String getDeployDirPath() {
		String fileSep = getHost().getFileSeparator();
		return getTomcatHome() + fileSep + getAppBase();
	}


	public String getContextWithoutVirtualHostDirPath() {
		String fileSep = getHost().getFileSeparator();
		return getTomcatHome() + fileSep + "conf" + fileSep + getService() + fileSep + "localhost";
	}



	public String getContextWithVirtualHostDirPath(String virtualHostName) {
		String fileSep = getHost().getFileSeparator();
		return getTomcatHome() + fileSep + "conf" + fileSep + getService() + fileSep + virtualHostName;
	}

	public String getStopCommand() {
		return stopCommand;
	}

	public void setStopCommand(String stopCommand) {
		this.stopCommand = stopCommand;
	}

	public String getStartCommand() {
		StringBuffer command = new StringBuffer();

		if (getHost().getOperatingSystemFamily() == OperatingSystemFamily.UNIX) {
			command.append("nohup ");
		}
		if (!StringUtils.isEmpty(startCommand)) {
			command.append(startCommand);
		}

		return command.toString();
	}

	public boolean isStartStopCommandAvailable() {
		return !StringUtils.isBlank(baseUrl) && !StringUtils.isBlank(startCommand) && !StringUtils.isBlank(stopCommand);
	}

	public void setStartCommand(String startCommand) {
		this.startCommand = startCommand;
	}

	private List<Step> getCheckSteps() {
		List<Step> steps = new ArrayList<Step>();
		steps.add(new HostConnectionStep(getHost()));
		steps.add(new CheckDirExistsStep(getHost(), getTomcatHome()));
		steps.add(new TomcatUnmanagedServerReachabilityTestStep(this));
		String[] startCommands = StringUtils.split(startCommand);
		String[] stopCommands = StringUtils.split(stopCommand);
		steps.add(new CheckFileExistenceStep(getHost(), startCommands[0], true, false, true));
		if (!stopCommands[0].equals(startCommands[0])) {
			steps.add(new CheckFileExistenceStep(getHost(), stopCommands[0], true, false, true));
		}

		return steps;
	}

	public TomcatUnmanagedServer discover(Map<String, Object> info, ChangePlan cp) {
		cp.addSteps(getCheckSteps());
		cp.execute(info);
		return this;
	}

	public TomcatUnmanagedServer discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
		return this;

	}

	public String getBaseUrl() {
		return baseUrl;
	}

	public void setBaseUrl(String baseUrl) {
		this.baseUrl = baseUrl;
	}

}
