/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat.mapper;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.plugin.tomcat.ci.*;
import com.xebialabs.deployit.plugin.tomcat.step.CreateTomcatResourceLinksStep;
import com.xebialabs.deployit.plugin.tomcat.step.DeleteTomcatResourceLinksStep;

import java.util.List;
import java.util.Map;


public class TomcatJndiResourcesToTomcatServerMapper extends WarMappingBasedTomcatServerMapper<TomcatJNDIResources, TomcatJNDIResourcesMapping, TomcatUnmanagedServer> {

	static final Function<Map.Entry<String, ResourceLinkValue>, ResourceLink> fromEntryToKVPair = new Function<Map.Entry<String, ResourceLinkValue>, ResourceLink>() {
		public ResourceLink apply(Map.Entry<String, ResourceLinkValue> from) {
			return new ResourceLink(from.getKey(), from.getValue());
		}
	};

	static final Function<Map.Entry<String, MapDifference.ValueDifference<ResourceLinkValue>>, ResourceLink> fromValueDifferenceToKVPair = new Function<Map.Entry<String, MapDifference.ValueDifference<ResourceLinkValue>>, ResourceLink>() {
		public ResourceLink apply(Map.Entry<String, MapDifference.ValueDifference<ResourceLinkValue>> from) {
			return new ResourceLink(from.getKey(), from.getValue().rightValue());
		}
	};

	public TomcatJndiResourcesToTomcatServerMapper(Change<Deployment> change, Mapper<War, TomcatWarMapping, TomcatUnmanagedServer>... tomcatServerMappers) {
		super(change, tomcatServerMappers);
	}

	static List<ResourceLink> resolveResourceLinks(TomcatJNDIResources resource, TomcatJNDIResourcesMapping mapping) {
		final List<ResourceLink> resolved = Lists.newArrayList();
		final MapDifference<String, ResourceLinkValue> difference = Maps.difference(resource.getResourceLinksAsMap(), mapping.getResourceLinksAsMap());

		resolved.addAll(Lists.transform(Lists.newArrayList(difference.entriesOnlyOnRight().entrySet()), fromEntryToKVPair));
		resolved.addAll(Lists.transform(Lists.newArrayList(difference.entriesOnlyOnLeft().entrySet()), fromEntryToKVPair));
		resolved.addAll(Lists.transform(Lists.newArrayList(difference.entriesDiffering().entrySet()), fromValueDifferenceToKVPair));
		resolved.addAll(Lists.transform(Lists.newArrayList(difference.entriesInCommon().entrySet()), fromEntryToKVPair));
		return resolved;
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(TomcatJNDIResources newMappingSource, TomcatJNDIResourcesMapping newMapping, TomcatUnmanagedServer newMappingTarget, TomcatWarMapping warMapping, List<Step> steps) {
		List<ResourceLink> resolvedResources = resolveResourceLinks(newMappingSource, newMapping);
		steps.add(new CreateTomcatResourceLinksStep(newMappingTarget, newMappingSource.getLabel(),warMapping, resolvedResources));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(TomcatJNDIResources oldMappingSource, TomcatJNDIResourcesMapping oldVersionOfModifiedMapping, TomcatUnmanagedServer oldMappingTarget, TomcatWarMapping warMapping, List<Step> steps) {
		List<ResourceLink> resolvedResources = resolveResourceLinks(oldMappingSource, oldVersionOfModifiedMapping);
		steps.add(new DeleteTomcatResourceLinksStep(oldMappingTarget, oldVersionOfModifiedMapping.getLabel(),warMapping, resolvedResources));
	}
}
