/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat.mapper;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**

 */
public abstract class WarMappingBasedTomcatServerMapper<S extends Serializable, M extends Mapping<? super S, ? super T>, T extends TomcatUnmanagedServer> extends
		StepGeneratingMapper<S, M, T> {
	private Mapper<War, TomcatWarMapping, T>[] tomcatServerMappers;

	public WarMappingBasedTomcatServerMapper(Change<Deployment> change, Mapper<War, TomcatWarMapping, T>... tomcatServerMappers) {
		super(change);
		this.tomcatServerMappers = tomcatServerMappers;


	}

	@Override
	protected void generateAdditionStepsForAddedMapping(S newMappingSource, M newMapping, T newMappingTarget, List<Step> steps) {
		Set<TomcatWarMapping> addedAndModifiedWarMappings = getAddedAndModifiedWarMappings();

		for (TomcatWarMapping warMapping : addedAndModifiedWarMappings) {
			if (warMapping.getTarget().equals(newMappingTarget)) {
				if (!StringUtils.isBlank(warMapping.getContextRoot())) {
					generateAdditionStepsForAddedMapping(newMappingSource, newMapping,newMappingTarget, warMapping, steps);
				} else {
					throw new ResolutionException("No war mapping with a set context root was found for " + warMapping.getSource());
				}
			}

		}
	}

	protected abstract void generateAdditionStepsForAddedMapping(S newMappingSource, M newMapping, T newMappingTarget, TomcatWarMapping warMapping,List<Step> steps) ;

	protected abstract void generateDeletionStepsForDeletedMapping(S oldMappingSource, M oldVersionOfModifiedMapping, T oldMappingTarget, TomcatWarMapping warMapping,List<Step> steps);


	@Override
	protected void generateDeletionStepsForDeletedMapping(S oldMappingSource, M oldVersionOfModifiedMapping, T oldMappingTarget, List<Step> steps) {
		Set<TomcatWarMapping> deletedAndModifiedMappings = getdeletedAndModifiedWarMappings();

		for (TomcatWarMapping warMapping : deletedAndModifiedMappings) {
			if (warMapping.getTarget().equals(oldMappingTarget)) {
				if (!StringUtils.isBlank(warMapping.getContextRoot())) {
					generateDeletionStepsForDeletedMapping(oldMappingSource,oldVersionOfModifiedMapping,oldMappingTarget,warMapping,steps);
				} else {
					throw new ResolutionException("No war mapping with a set context root was found for " + warMapping.getSource());
				}
			}

		}
	}

	private Set<TomcatWarMapping> getdeletedAndModifiedWarMappings() {
		Set<TomcatWarMapping> warMappings = Sets.newHashSet();
		for (Mapper<War, TomcatWarMapping, T> mapper : tomcatServerMappers) {
			warMappings.addAll(mapper.getOldMappings());
		}
		return warMappings;
	}

	private Set<TomcatWarMapping> getAddedAndModifiedWarMappings() {
		Set<TomcatWarMapping> warMappings = Sets.newHashSet();
		for (Mapper<War, TomcatWarMapping, T> mapper : tomcatServerMappers) {
			warMappings.addAll(mapper.getNewMappings());
		}
		return warMappings;
	}
}
